/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.revapi.gradle.ExceptionMessages;
import org.revapi.gradle.PreviousVersionResolutionHelpers;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.Version;

final class OldApiConfigurations {
    private OldApiConfigurations() {
    }

    static Set<File> resolveOldConfiguration(Project project, GroupNameVersion groupNameVersion, boolean transitive) throws CouldNotResolveOldApiException {
        Dependency oldApiDependency = project.getDependencies().create((Object)groupNameVersion.asString());
        Configuration oldApiConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        oldApiConfiguration.getDependencies().add((Object)oldApiDependency);
        oldApiConfiguration.setTransitive(transitive);
        return PreviousVersionResolutionHelpers.withRenamedGroupForCurrentThread(project, () -> OldApiConfigurations.resolveConfigurationUnlessMissingJars(groupNameVersion.version(), oldApiConfiguration));
    }

    private static Set<File> resolveConfigurationUnlessMissingJars(Version oldVersion, Configuration configuration) throws CouldNotResolveOldApiException {
        Set allDependencies = configuration.getIncoming().getResolutionResult().getAllDependencies();
        List<Throwable> resolutionFailures = allDependencies.stream().filter(dependencyResult -> dependencyResult instanceof UnresolvedDependencyResult).map(dependencyResult -> (UnresolvedDependencyResult)dependencyResult).map(UnresolvedDependencyResult::getFailure).collect(Collectors.toList());
        if (resolutionFailures.isEmpty()) {
            return configuration.resolve();
        }
        throw new CouldNotResolveOldApiException(oldVersion, resolutionFailures);
    }

    static final class CouldNotResolveOldApiException
    extends Exception {
        private final Version version;
        private final List<Throwable> resolutionFailures;

        CouldNotResolveOldApiException(Version version, List<Throwable> resolutionFailures) {
            this.version = version;
            this.resolutionFailures = resolutionFailures;
        }

        @Override
        public String getMessage() {
            return "We tried version " + this.version.asString() + " but it failed with errors:\n\n" + ExceptionMessages.joined(this.resolutionFailures);
        }
    }
}

