/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.AnalysisResult;
import org.revapi.Revapi;
import org.revapi.gradle.CheckWhitelist;
import org.revapi.gradle.ConjureProjectFilters;
import org.revapi.gradle.ImmutablesFilter;
import org.revapi.gradle.RevapiConfig;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.java.JavaApiAnalyzer;
import org.revapi.reporter.text.TextReporter;
import org.revapi.simple.FileArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTask
public class RevapiAnalyzeTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(RevapiAnalyzeTask.class);
    private final SetProperty<AcceptedBreak> acceptedBreaks = this.getProject().getObjects().setProperty(AcceptedBreak.class);
    private final Property<FileCollection> newApiJars = this.getProject().getObjects().property(FileCollection.class);
    private final Property<FileCollection> newApiDependencyJars = this.getProject().getObjects().property(FileCollection.class);
    private final Property<FileCollection> jarsToReportBreaks = this.getProject().getObjects().property(FileCollection.class);
    private final Property<FileCollection> oldApiJars = this.getProject().getObjects().property(FileCollection.class);
    private final Property<FileCollection> oldApiDependencyJars = this.getProject().getObjects().property(FileCollection.class);
    private final RegularFileProperty analysisResultsFile = this.getProject().getObjects().fileProperty();

    @Input
    public final SetProperty<AcceptedBreak> getAcceptedBreaks() {
        return this.acceptedBreaks;
    }

    @CompileClasspath
    public final Property<FileCollection> getNewApiJars() {
        return this.newApiJars;
    }

    @CompileClasspath
    public final Property<FileCollection> getNewApiDependencyJars() {
        return this.newApiDependencyJars;
    }

    @CompileClasspath
    public final Property<FileCollection> getJarsToReportBreaks() {
        return this.jarsToReportBreaks;
    }

    @CompileClasspath
    public final Property<FileCollection> getOldApiJars() {
        return this.oldApiJars;
    }

    @CompileClasspath
    public final Property<FileCollection> getOldApiDependencyJars() {
        return this.oldApiDependencyJars;
    }

    @OutputFile
    public final RegularFileProperty getAnalysisResultsFile() {
        return this.analysisResultsFile;
    }

    @TaskAction
    protected final void runRevapi() throws Exception {
        API oldApi = this.api((Provider<FileCollection>)this.oldApiJars, (Provider<FileCollection>)this.oldApiDependencyJars);
        API newApi = this.api((Provider<FileCollection>)this.newApiJars, (Provider<FileCollection>)this.newApiDependencyJars);
        log.info("Old API: {}", (Object)oldApi);
        log.info("New API: {}", (Object)newApi);
        Revapi revapi = Revapi.builder().withAllExtensionsFromThreadContextClassLoader().withAnalyzers(new Class[]{JavaApiAnalyzer.class}).withReporters(new Class[]{TextReporter.class}).withTransforms(new Class[]{CheckWhitelist.class, ImmutablesFilter.class}).build();
        RevapiConfig revapiConfig = RevapiConfig.mergeAll(RevapiConfig.defaults((FileCollection)this.jarsToReportBreaks.get()), RevapiConfig.empty().withTextReporter("gradle-revapi-results.ftl", (File)this.analysisResultsFile.getAsFile().get()), this.revapiIgnores(), ConjureProjectFilters.forProject(this.getProject()), ImmutablesFilter.CONFIG);
        log.info("revapi config:\n{}", (Object)revapiConfig.configAsString());
        try (AnalysisResult analysisResult = revapi.analyze(AnalysisContext.builder().withOldAPI(oldApi).withNewAPI(newApi).withConfigurationFromJSON(revapiConfig.configAsString()).build());){
            analysisResult.throwIfFailed();
        }
    }

    private RevapiConfig revapiIgnores() {
        return RevapiConfig.empty().withIgnoredBreaks((Set)this.acceptedBreaks.get());
    }

    private API api(Provider<FileCollection> apiJars, Provider<FileCollection> dependencyJars) {
        return API.builder().addArchives(RevapiAnalyzeTask.toFileArchives(apiJars)).addSupportArchives(RevapiAnalyzeTask.toFileArchives(dependencyJars)).build();
    }

    private static List<FileArchive> toFileArchives(Provider<FileCollection> property) {
        return ((FileCollection)property.get()).filter(File::isFile).getFiles().stream().map(FileArchive::new).collect(Collectors.toList());
    }
}

