/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Comparator;
import java.util.Optional;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.revapi.gradle.config.ImmutableAcceptedBreak;
import org.revapi.gradle.config.Justification;

@JsonDeserialize(as=ImmutableAcceptedBreak.class)
@Value.Immutable
@Serial.Structural
public interface AcceptedBreak
extends Comparable<AcceptedBreak> {
    @JsonProperty(value="code")
    public String code();

    @JsonProperty(value="old")
    public Optional<String> oldElement();

    @JsonProperty(value="new")
    public Optional<String> newElement();

    @JsonProperty(value="justification")
    public Justification justification();

    @Value.Lazy
    default public Comparator<AcceptedBreak> comparator() {
        Comparator<Optional> comparingEmptiesFirst = Comparator.comparing(element -> element.orElse(null), Comparator.nullsFirst(Comparator.naturalOrder()));
        return Comparator.comparing(AcceptedBreak::code).thenComparing(AcceptedBreak::oldElement, comparingEmptiesFirst).thenComparing(AcceptedBreak::newElement, comparingEmptiesFirst);
    }

    @Override
    default public int compareTo(AcceptedBreak other) {
        return this.comparator().compare(this, other);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableAcceptedBreak.Builder {
        public Builder justification(String justification) {
            this.justification(Justification.fromString(justification));
            return this;
        }
    }
}

