/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.GroupAndName;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.ImmutableGradleRevapiConfig;
import org.revapi.gradle.config.PerProjectAcceptedBreaks;
import org.revapi.gradle.config.Version;

@JsonDeserialize(as=ImmutableGradleRevapiConfig.class)
@Value.Immutable
public abstract class GradleRevapiConfig {
    @Value.NaturalOrder
    protected abstract SortedMap<GroupNameVersion, String> versionOverrides();

    @Value.NaturalOrder
    protected abstract SortedMap<Version, PerProjectAcceptedBreaks> acceptedBreaks();

    public final Optional<Version> versionOverrideFor(GroupNameVersion groupNameVersion) {
        return Optional.ofNullable((String)this.versionOverrides().get(groupNameVersion)).map(Version::fromString);
    }

    public final GradleRevapiConfig addVersionOverride(GroupNameVersion groupNameVersion, String versionOverride) {
        return ImmutableGradleRevapiConfig.builder().from(this).putVersionOverrides(groupNameVersion, versionOverride).build();
    }

    public final Set<AcceptedBreak> acceptedBreaksFor(GroupAndName groupNameVersion) {
        return this.acceptedBreaks().values().stream().flatMap(perProjectAcceptedBreaks -> perProjectAcceptedBreaks.acceptedBreaksFor(groupNameVersion).stream()).collect(Collectors.toSet());
    }

    public final GradleRevapiConfig addAcceptedBreaks(GroupNameVersion groupNameVersion, Set<AcceptedBreak> acceptedBreaks) {
        PerProjectAcceptedBreaks existingAcceptedBreaks = this.acceptedBreaks().getOrDefault(groupNameVersion.version(), PerProjectAcceptedBreaks.empty());
        PerProjectAcceptedBreaks newPerProjectAcceptedBreaks = existingAcceptedBreaks.merge(groupNameVersion.groupAndName(), acceptedBreaks);
        HashMap<Version, PerProjectAcceptedBreaks> newAcceptedBreaks = new HashMap<Version, PerProjectAcceptedBreaks>(this.acceptedBreaks());
        newAcceptedBreaks.put(groupNameVersion.version(), newPerProjectAcceptedBreaks);
        return ImmutableGradleRevapiConfig.builder().from(this).acceptedBreaks(newAcceptedBreaks).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GradleRevapiConfig empty() {
        return GradleRevapiConfig.builder().build();
    }

    public static ObjectMapper newYamlObjectMapper() {
        return GradleRevapiConfig.configureObjectMapper(new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)));
    }

    public static ObjectMapper newJsonObjectMapper() {
        return GradleRevapiConfig.configureObjectMapper(new ObjectMapper()).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_TRAILING_COMMA});
    }

    private static ObjectMapper configureObjectMapper(ObjectMapper objectMapper) {
        return objectMapper.registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static class Builder
    extends ImmutableGradleRevapiConfig.Builder {
    }
}

