/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Splitter;
import java.util.List;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.revapi.gradle.config.GroupNameVersion;
import org.revapi.gradle.config.ImmutableGroupAndName;
import org.revapi.gradle.config.Version;

@Value.Immutable
@Serial.Structural
public interface GroupAndName
extends Comparable<GroupAndName> {
    public String group();

    public String name();

    @JsonValue
    default public String asString() {
        return String.join((CharSequence)":", this.group(), this.name());
    }

    @JsonCreator
    public static GroupAndName fromString(String groupAndName) {
        List split = Splitter.on((String)":").splitToList((CharSequence)groupAndName);
        if (split.size() != 2) {
            throw new IllegalArgumentException(String.format("%s could not be split into group and name", groupAndName));
        }
        return GroupAndName.builder().group((String)split.get(0)).name((String)split.get(1)).build();
    }

    @Override
    default public int compareTo(GroupAndName other) {
        return this.asString().compareTo(other.asString());
    }

    default public GroupNameVersion withVersion(Version version) {
        return GroupNameVersion.builder().groupAndName(this).version(version).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableGroupAndName.Builder {
    }
}

