/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Splitter;
import java.util.List;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.revapi.gradle.config.GroupAndName;
import org.revapi.gradle.config.ImmutableGroupNameVersion;
import org.revapi.gradle.config.Version;

@Value.Immutable
@Serial.Structural
public interface GroupNameVersion
extends Comparable<GroupNameVersion> {
    public GroupAndName groupAndName();

    public Version version();

    @JsonValue
    default public String asString() {
        return String.join((CharSequence)":", this.groupAndName().group(), this.groupAndName().name(), this.version().asString());
    }

    @JsonCreator
    public static GroupNameVersion fromString(String groupNameVersionString) {
        List split = Splitter.on((String)":").splitToList((CharSequence)groupNameVersionString);
        if (split.size() != 3) {
            throw new IllegalArgumentException(String.format("%s could not be split into group name and version", groupNameVersionString));
        }
        return GroupNameVersion.builder().groupAndName(GroupAndName.builder().group((String)split.get(0)).name((String)split.get(1)).build()).version(Version.fromString((String)split.get(2))).build();
    }

    @Override
    default public int compareTo(GroupNameVersion other) {
        return this.asString().compareTo(other.asString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableGroupNameVersion.Builder {
    }
}

