/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.Justification;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AcceptedBreak", generator="Immutables")
@Immutable
final class ImmutableAcceptedBreak
implements AcceptedBreak,
Serializable {
    private final String code;
    @Nullable
    private final String oldElement;
    @Nullable
    private final String newElement;
    private final Justification justification;
    private volatile transient long lazyInitBitmap;
    private static final long COMPARATOR_LAZY_INIT_BIT = 1L;
    private transient Comparator<AcceptedBreak> comparator;

    private ImmutableAcceptedBreak(String code, @Nullable String oldElement, @Nullable String newElement, Justification justification) {
        this.code = code;
        this.oldElement = oldElement;
        this.newElement = newElement;
        this.justification = justification;
    }

    @Override
    @JsonProperty(value="code")
    public String code() {
        return this.code;
    }

    @Override
    @JsonProperty(value="old")
    public Optional<String> oldElement() {
        return Optional.ofNullable(this.oldElement);
    }

    @Override
    @JsonProperty(value="new")
    public Optional<String> newElement() {
        return Optional.ofNullable(this.newElement);
    }

    @Override
    @JsonProperty(value="justification")
    public Justification justification() {
        return this.justification;
    }

    public final ImmutableAcceptedBreak withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableAcceptedBreak(newValue, this.oldElement, this.newElement, this.justification);
    }

    public final ImmutableAcceptedBreak withOldElement(String value) {
        String newValue = Objects.requireNonNull(value, "oldElement");
        if (Objects.equals(this.oldElement, newValue)) {
            return this;
        }
        return new ImmutableAcceptedBreak(this.code, newValue, this.newElement, this.justification);
    }

    public final ImmutableAcceptedBreak withOldElement(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.oldElement, value)) {
            return this;
        }
        return new ImmutableAcceptedBreak(this.code, value, this.newElement, this.justification);
    }

    public final ImmutableAcceptedBreak withNewElement(String value) {
        String newValue = Objects.requireNonNull(value, "newElement");
        if (Objects.equals(this.newElement, newValue)) {
            return this;
        }
        return new ImmutableAcceptedBreak(this.code, this.oldElement, newValue, this.justification);
    }

    public final ImmutableAcceptedBreak withNewElement(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.newElement, value)) {
            return this;
        }
        return new ImmutableAcceptedBreak(this.code, this.oldElement, value, this.justification);
    }

    public final ImmutableAcceptedBreak withJustification(Justification value) {
        if (this.justification == value) {
            return this;
        }
        Justification newValue = Objects.requireNonNull(value, "justification");
        return new ImmutableAcceptedBreak(this.code, this.oldElement, this.newElement, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptedBreak && this.equalTo(0, (ImmutableAcceptedBreak)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptedBreak another) {
        return this.code.equals(another.code) && Objects.equals(this.oldElement, another.oldElement) && Objects.equals(this.newElement, another.newElement) && this.justification.equals(another.justification);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + Objects.hashCode(this.oldElement);
        h += (h << 5) + Objects.hashCode(this.newElement);
        h += (h << 5) + this.justification.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AcceptedBreak{");
        builder.append("code=").append(this.code);
        if (this.oldElement != null) {
            builder.append(", ");
            builder.append("oldElement=").append(this.oldElement);
        }
        if (this.newElement != null) {
            builder.append(", ");
            builder.append("newElement=").append(this.newElement);
        }
        builder.append(", ");
        builder.append("justification=").append(this.justification);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAcceptedBreak fromJson(Json json) {
        AcceptedBreak.Builder builder = new AcceptedBreak.Builder();
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.oldElement != null) {
            builder.oldElement(json.oldElement);
        }
        if (json.newElement != null) {
            builder.newElement(json.newElement);
        }
        if (json.justification != null) {
            builder.justification(json.justification);
        }
        return (ImmutableAcceptedBreak)builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comparator<AcceptedBreak> comparator() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableAcceptedBreak immutableAcceptedBreak = this;
            synchronized (immutableAcceptedBreak) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.comparator = Objects.requireNonNull(AcceptedBreak.super.comparator(), "comparator");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.comparator;
    }

    public static AcceptedBreak copyOf(AcceptedBreak instance) {
        if (instance instanceof ImmutableAcceptedBreak) {
            return (ImmutableAcceptedBreak)instance;
        }
        return new AcceptedBreak.Builder().from(instance).build();
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    @Generated(from="AcceptedBreak", generator="Immutables")
    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_JUSTIFICATION = 2L;
        private long initBits = 3L;
        @Nullable
        private String code;
        @Nullable
        private String oldElement;
        @Nullable
        private String newElement;
        @Nullable
        private Justification justification;

        Builder() {
            if (!(this instanceof AcceptedBreak.Builder)) {
                throw new UnsupportedOperationException("Use: new AcceptedBreak.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder from(AcceptedBreak instance) {
            Optional<String> newElementOptional;
            Objects.requireNonNull(instance, "instance");
            this.code(instance.code());
            Optional<String> oldElementOptional = instance.oldElement();
            if (oldElementOptional.isPresent()) {
                this.oldElement(oldElementOptional);
            }
            if ((newElementOptional = instance.newElement()).isPresent()) {
                this.newElement(newElementOptional);
            }
            this.justification(instance.justification());
            return (AcceptedBreak.Builder)this;
        }

        @JsonProperty(value="code")
        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (AcceptedBreak.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder oldElement(String oldElement) {
            this.oldElement = Objects.requireNonNull(oldElement, "oldElement");
            return (AcceptedBreak.Builder)this;
        }

        @JsonProperty(value="old")
        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder oldElement(Optional<String> oldElement) {
            this.oldElement = oldElement.orElse(null);
            return (AcceptedBreak.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder newElement(String newElement) {
            this.newElement = Objects.requireNonNull(newElement, "newElement");
            return (AcceptedBreak.Builder)this;
        }

        @JsonProperty(value="new")
        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder newElement(Optional<String> newElement) {
            this.newElement = newElement.orElse(null);
            return (AcceptedBreak.Builder)this;
        }

        @JsonProperty(value="justification")
        @CanIgnoreReturnValue
        public final AcceptedBreak.Builder justification(Justification justification) {
            this.justification = Objects.requireNonNull(justification, "justification");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (AcceptedBreak.Builder)this;
        }

        public AcceptedBreak build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptedBreak(this.code, this.oldElement, this.newElement, this.justification);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("justification");
            }
            return "Cannot build AcceptedBreak, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AcceptedBreak", generator="Immutables")
    private static class SerialForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String[] names;
        private final Object[] values;

        SerialForm(ImmutableAcceptedBreak instance) {
            ArrayList<String> names = new ArrayList<String>(4);
            ArrayList<Object> values = new ArrayList<Object>(4);
            names.add("code");
            values.add(instance.code());
            if (instance.oldElement().isPresent()) {
                names.add("oldElement");
                values.add(instance.oldElement().get());
            }
            if (instance.newElement().isPresent()) {
                names.add("newElement");
                values.add(instance.newElement().get());
            }
            names.add("justification");
            values.add(instance.justification());
            this.names = names.toArray(new String[names.size()]);
            this.values = values.toArray();
        }

        Object readResolve() {
            AcceptedBreak.Builder builder = new AcceptedBreak.Builder();
            for (int i = 0; i < this.names.length; ++i) {
                String name = this.names[i];
                if ("code".equals(name)) {
                    builder.code((String)SerialForm.toSingle("code", this.values[i]));
                    continue;
                }
                if ("oldElement".equals(name)) {
                    if (this.values[i] == null) continue;
                    builder.oldElement((String)this.values[i]);
                    continue;
                }
                if ("newElement".equals(name)) {
                    if (this.values[i] == null) continue;
                    builder.newElement((String)this.values[i]);
                    continue;
                }
                if (!"justification".equals(name)) continue;
                builder.justification((Justification)SerialForm.toSingle("justification", this.values[i]));
            }
            return builder.build();
        }

        private static Object toSingle(String attribute, Object value) {
            if (value instanceof Object[]) {
                Object[] elements = (Object[])value;
                if (elements.length == 1) {
                    return elements[0];
                }
                throw new IllegalStateException("Cannot extract scalar value for attribute '" + attribute + "' from array of length " + elements.length);
            }
            return value;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AcceptedBreak", generator="Immutables")
    static final class Json
    implements AcceptedBreak,
    Serializable {
        @Nullable
        String code;
        @Nullable
        Optional<String> oldElement = Optional.empty();
        @Nullable
        Optional<String> newElement = Optional.empty();
        @Nullable
        Justification justification;

        Json() {
        }

        @JsonProperty(value="code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="old")
        public void setOldElement(Optional<String> oldElement) {
            this.oldElement = oldElement;
        }

        @JsonProperty(value="new")
        public void setNewElement(Optional<String> newElement) {
            this.newElement = newElement;
        }

        @JsonProperty(value="justification")
        public void setJustification(Justification justification) {
            this.justification = justification;
        }

        @Override
        public String code() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> oldElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> newElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Justification justification() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparator<AcceptedBreak> comparator() {
            throw new UnsupportedOperationException();
        }
    }
}

