/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.validator;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.validator.Validator;

public class ImplementsValidator
extends Validator {
    public static final String IMPLEMENTS_CLASS = "org.robolectric.annotation.Implements";

    public ImplementsValidator(RobolectricModel model, ProcessingEnvironment env) {
        super(model, env, IMPLEMENTS_CLASS);
    }

    private TypeElement getClassNameTypeElement(AnnotationValue cv) {
        String className = RobolectricModel.classNameVisitor.visit(cv);
        TypeElement type = this.elements.getTypeElement(className.replace('$', '.'));
        if (type == null) {
            this.error("@Implements: could not resolve class <" + className + '>', cv);
            return null;
        }
        return type;
    }

    @Override
    public Void visitType(TypeElement elem, Element parent) {
        List<? extends TypeParameterElement> elemTP;
        AnnotationMirror am = this.getCurrentAnnotation();
        AnnotationValue av = RobolectricModel.getAnnotationValue(am, "value");
        AnnotationValue cv = RobolectricModel.getAnnotationValue(am, "className");
        TypeElement type = null;
        if (av == null) {
            if (cv == null) {
                this.error("@Implements: must specify <value> or <className>");
                return null;
            }
            type = this.getClassNameTypeElement(cv);
        } else {
            boolean isAnything;
            TypeMirror value = RobolectricModel.valueVisitor.visit(av);
            if (value == null) {
                return null;
            }
            boolean bl = isAnything = this.model.ANYTHING_MIRROR != null && this.types.isSameType(value, this.model.ANYTHING_MIRROR);
            if (isAnything) {
                if (cv == null) {
                    this.error("@Implements: Anything class specified but no <className> attribute");
                    return null;
                }
                type = this.getClassNameTypeElement(cv);
            } else if (cv != null) {
                this.error("@Implements: cannot specify both <value> and <className> attributes");
            } else {
                type = RobolectricModel.typeVisitor.visit(this.types.asElement(value));
            }
        }
        if (type == null) {
            return null;
        }
        List<? extends TypeParameterElement> typeTP = type.getTypeParameters();
        if (!this.model.isSameParameterList(typeTP, elemTP = elem.getTypeParameters())) {
            StringBuilder message = new StringBuilder();
            if (elemTP.isEmpty()) {
                message.append("Shadow type is missing type parameters, expected <");
                this.model.appendParameterList(message, type.getTypeParameters());
                message.append('>');
            } else if (typeTP.isEmpty()) {
                message.append("Shadow type has type parameters but real type does not");
            } else {
                message.append("Shadow type must have same type parameters as its real counterpart: expected <");
                this.model.appendParameterList(message, type.getTypeParameters());
                message.append(">, was <");
                this.model.appendParameterList(message, elem.getTypeParameters());
                message.append('>');
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, message, elem);
            return null;
        }
        this.model.addShadowType(elem, type);
        return null;
    }
}

