/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.validator;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.robolectric.annotation.processing.RobolectricModel;
import org.robolectric.annotation.processing.validator.FoundOnImplementsValidator;

public class ResetterValidator
extends FoundOnImplementsValidator {
    public ResetterValidator(RobolectricModel model, ProcessingEnvironment env) {
        super(model, env, "org.robolectric.annotation.Resetter");
    }

    @Override
    public Void visitExecutable(ExecutableElement elem, TypeElement parent) {
        if (this.imp != null) {
            List<? extends VariableElement> params;
            Set<Modifier> modifiers = elem.getModifiers();
            boolean error = false;
            if (!modifiers.contains((Object)Modifier.STATIC)) {
                this.error("@Resetter methods must be static");
                error = true;
            }
            if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                this.error("@Resetter methods must be public");
                error = true;
            }
            if ((params = elem.getParameters()) != null && !params.isEmpty()) {
                this.error("@Resetter methods must not have parameters");
                error = true;
            }
            if (!error) {
                this.model.addResetter(parent, elem);
            }
        }
        return null;
    }
}

