/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.annotation.processing.validator;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.AbstractElementVisitor6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.robolectric.annotation.processing.RobolectricModel;

public abstract class Validator
implements ElementVisitor<Void, Element> {
    protected final RobolectricModel model;
    protected final Elements elements;
    protected final Types types;
    protected final Messager messager;
    protected final TypeElement annotationType;
    final ElementVisitor<Void, Element> visitorAdapter = new AbstractElementVisitor6<Void, Element>(){

        @Override
        public Void visitPackage(PackageElement e, Element p) {
            return Validator.this.visitPackage(e, p);
        }

        @Override
        public Void visitType(TypeElement e, Element p) {
            return Validator.this.visitType(e, p);
        }

        @Override
        public Void visitVariable(VariableElement e, Element p) {
            return Validator.this.visitVariable(e, p);
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Element p) {
            return Validator.this.visitExecutable(e, p);
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Element p) {
            return Validator.this.visitTypeParameter(e, p);
        }
    };
    protected Element currentElement;
    protected AnnotationMirror currentAnnotation;

    public Validator(RobolectricModel model, ProcessingEnvironment env, String annotationType) {
        this.model = model;
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.messager = env.getMessager();
        this.annotationType = this.elements.getTypeElement(annotationType);
    }

    protected AnnotationMirror getCurrentAnnotation() {
        if (this.currentAnnotation == null) {
            this.currentAnnotation = this.model.getAnnotationMirror(this.currentElement, this.annotationType);
        }
        return this.currentAnnotation;
    }

    protected void message(Diagnostic.Kind severity, String msg, AnnotationValue av) {
        AnnotationMirror am = this.getCurrentAnnotation();
        this.messager.printMessage(severity, msg, this.currentElement, am, av);
    }

    protected void message(Diagnostic.Kind severity, String msg) {
        AnnotationMirror am = this.getCurrentAnnotation();
        this.messager.printMessage(severity, msg, this.currentElement, am);
    }

    protected void error(String msg) {
        this.message(Diagnostic.Kind.ERROR, msg);
    }

    protected void error(String msg, AnnotationValue av) {
        this.message(Diagnostic.Kind.ERROR, msg, av);
    }

    public void init(Element e, Element p) {
        this.currentElement = e;
        this.currentAnnotation = null;
    }

    public TypeElement getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public Void visit(Element e, Element p) {
        this.init(e, p);
        return this.visitorAdapter.visit(e, p);
    }

    @Override
    public Void visit(Element e) {
        return this.visit(e, null);
    }

    @Override
    public Void visitPackage(PackageElement e, Element p) {
        return null;
    }

    @Override
    public Void visitType(TypeElement e, Element p) {
        return null;
    }

    @Override
    public Void visitVariable(VariableElement e, Element p) {
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Element p) {
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement e, Element p) {
        return null;
    }

    @Override
    public Void visitUnknown(Element e, Element p) {
        return null;
    }
}

