/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.database.DatabaseUtils;
import android.net.Uri;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.fakes.BaseCursor;

public class RoboCursor
extends BaseCursor {
    public Uri uri;
    public String[] projection;
    public String selection;
    public String[] selectionArgs;
    public String sortOrder;
    protected Object[][] results = new Object[0][0];
    protected List<String> columnNames = new ArrayList<String>();
    private int resultsIndex = -1;
    private boolean closeWasCalled;

    @Override
    public void setQuery(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        this.uri = uri;
        this.projection = projection;
        this.selection = selection;
        this.selectionArgs = selectionArgs;
        this.sortOrder = sortOrder;
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
        int col = this.getColumnIndex(columnName);
        if (col == -1) {
            throw new IllegalArgumentException("No column with name: " + columnName);
        }
        return col;
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.columnNames.indexOf(columnName);
    }

    @Override
    public String getString(int columnIndex) {
        return (String)this.results[this.resultsIndex][columnIndex];
    }

    @Override
    public long getLong(int columnIndex) {
        return (Long)this.results[this.resultsIndex][columnIndex];
    }

    @Override
    public int getInt(int columnIndex) {
        return (Integer)this.results[this.resultsIndex][columnIndex];
    }

    @Override
    public int getCount() {
        return this.results.length;
    }

    @Override
    public boolean moveToNext() {
        return this.doMoveToPosition(this.resultsIndex + 1);
    }

    @Override
    public boolean moveToFirst() {
        return this.doMoveToPosition(0);
    }

    @Override
    public boolean moveToPosition(int position) {
        return this.doMoveToPosition(position);
    }

    private boolean doMoveToPosition(int position) {
        this.resultsIndex = position;
        return this.resultsIndex >= 0 && this.resultsIndex < this.results.length;
    }

    @Override
    public void close() {
        this.closeWasCalled = true;
    }

    @Override
    public int getColumnCount() {
        return this.results[0].length;
    }

    @Override
    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    @Override
    public int getType(int columnIndex) {
        return DatabaseUtils.getTypeOfObject((Object)this.results[0][columnIndex]);
    }

    @Override
    public boolean isBeforeFirst() {
        return this.resultsIndex < 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.resultsIndex > this.results.length - 1;
    }

    @Override
    public boolean isFirst() {
        return this.resultsIndex == 0;
    }

    @Override
    public boolean isLast() {
        return this.resultsIndex == this.results.length - 1;
    }

    @Override
    public int getPosition() {
        return this.resultsIndex;
    }

    @Override
    public boolean move(int offset) {
        return this.doMoveToPosition(this.resultsIndex + offset);
    }

    @Override
    public boolean moveToLast() {
        return this.doMoveToPosition(this.results.length - 1);
    }

    @Override
    public boolean moveToPrevious() {
        return this.doMoveToPosition(this.resultsIndex - 1);
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    @Override
    public byte[] getBlob(int columnIndex) {
        return (byte[])this.results[this.resultsIndex][columnIndex];
    }

    @Override
    public short getShort(int columnIndex) {
        return (Short)this.results[this.resultsIndex][columnIndex];
    }

    @Override
    public float getFloat(int columnIndex) {
        return ((Float)this.results[this.resultsIndex][columnIndex]).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        return (Double)this.results[this.resultsIndex][columnIndex];
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.results[this.resultsIndex][columnIndex] == null;
    }

    @Override
    public boolean isClosed() {
        return this.closeWasCalled;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void setResults(Object[][] results) {
        this.results = results;
    }

    public boolean getCloseWasCalled() {
        return this.closeWasCalled;
    }
}

