/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityManager;
import android.content.pm.ConfigurationInfo;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ActivityManager.class)
public class ShadowActivityManager {
    private int memoryClass = 16;
    private String backgroundPackage;
    private ActivityManager.MemoryInfo memoryInfo;
    private final List<ActivityManager.RunningTaskInfo> tasks = new ArrayList<ActivityManager.RunningTaskInfo>();
    private final List<ActivityManager.RunningServiceInfo> services = new ArrayList<ActivityManager.RunningServiceInfo>();
    private final List<ActivityManager.RunningAppProcessInfo> processes = new ArrayList<ActivityManager.RunningAppProcessInfo>();

    @Implementation
    public int getMemoryClass() {
        return this.memoryClass;
    }

    @Implementation
    public static boolean isUserAMonkey() {
        return false;
    }

    @Implementation
    public List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return this.tasks;
    }

    @Implementation
    public List<ActivityManager.RunningServiceInfo> getRunningServices(int maxNum) {
        return this.services;
    }

    @Implementation
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        return this.processes;
    }

    @Implementation
    public void killBackgroundProcesses(String packageName) {
        this.backgroundPackage = packageName;
    }

    @Implementation
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (this.memoryInfo != null) {
            outInfo.availMem = this.memoryInfo.availMem;
            outInfo.lowMemory = this.memoryInfo.lowMemory;
            outInfo.threshold = this.memoryInfo.threshold;
            outInfo.totalMem = this.memoryInfo.totalMem;
        }
    }

    @Implementation
    public ConfigurationInfo getDeviceConfigurationInfo() {
        return new ConfigurationInfo();
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
    }

    public void setServices(List<ActivityManager.RunningServiceInfo> services) {
        this.services.clear();
        this.services.addAll(services);
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        this.processes.clear();
        this.processes.addAll(processes);
    }

    public String getBackgroundPackage() {
        return this.backgroundPackage;
    }

    public void setMemoryClass(int memoryClass) {
        this.memoryClass = memoryClass;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }
}

