/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.appwidget.AppWidgetManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import android.view.Display;
import android.view.LayoutInflater;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.Toast;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.RoboSettings;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.Shadow;
import org.robolectric.internal.ShadowExtractor;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.manifest.BroadcastReceiverData;
import org.robolectric.shadows.Provider;
import org.robolectric.shadows.ShadowAlertDialog;
import org.robolectric.shadows.ShadowBroadcastPendingResult;
import org.robolectric.shadows.ShadowBroadcastReceiver;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowContextWrapper;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.shadows.ShadowPopupMenu;
import org.robolectric.util.Scheduler;

@Implements(value=Application.class)
public class ShadowApplication
extends ShadowContextWrapper {
    @RealObject
    private Application realApplication;
    private AndroidManifest appManifest;
    private List<Intent> startedActivities = new ArrayList<Intent>();
    private List<Intent.FilterComparison> startedServices = new ArrayList<Intent.FilterComparison>();
    private List<Intent.FilterComparison> stoppedServices = new ArrayList<Intent.FilterComparison>();
    private List<Intent> broadcastIntents = new ArrayList<Intent>();
    private List<ServiceConnection> boundServiceConnections = new ArrayList<ServiceConnection>();
    private List<ServiceConnection> unboundServiceConnections = new ArrayList<ServiceConnection>();
    private List<Wrapper> registeredReceivers = new ArrayList<Wrapper>();
    private Map<String, Intent> stickyIntents = new LinkedHashMap<String, Intent>();
    private Handler mainHandler;
    private Scheduler backgroundScheduler = RoboSettings.isUseGlobalScheduler() ? this.getForegroundThreadScheduler() : new Scheduler();
    private ArrayList<Toast> shownToasts = new ArrayList();
    private PowerManager.WakeLock latestWakeLock;
    private ShadowAlertDialog latestAlertDialog;
    private ShadowDialog latestDialog;
    private ShadowPopupMenu latestPopupMenu;
    private Object bluetoothAdapter = Shadow.newInstanceOf((String)"android.bluetooth.BluetoothAdapter");
    private Set<String> grantedPermissions = new HashSet<String>();
    private boolean unbindServiceShouldThrowIllegalArgument = false;
    private Map<Intent.FilterComparison, ServiceConnectionDataWrapper> serviceConnectionDataForIntent = new HashMap<Intent.FilterComparison, ServiceConnectionDataWrapper>();
    private Map<ServiceConnection, ServiceConnectionDataWrapper> serviceConnectionDataForServiceConnection = new HashMap<ServiceConnection, ServiceConnectionDataWrapper>();
    private ServiceConnectionDataWrapper defaultServiceConnectionData = new ServiceConnectionDataWrapper(null, null);
    LayoutInflater layoutInflater;
    AppWidgetManager appWidgetManager;
    private List<String> unbindableActions = new ArrayList<String>();
    private boolean checkActivities;
    private PopupWindow latestPopupWindow;
    private ListPopupWindow latestListPopupWindow;
    private final Map<String, Object> singletons = new HashMap<String, Object>();

    public static ShadowApplication getInstance() {
        return RuntimeEnvironment.application == null ? null : Shadows.shadowOf(RuntimeEnvironment.application);
    }

    public static void runBackgroundTasks() {
        ShadowApplication.getInstance().getBackgroundThreadScheduler().advanceBy(0L);
    }

    public static void setDisplayMetricsDensity(float densityMultiplier) {
        Shadows.shadowOf(RuntimeEnvironment.application.getResources()).setDensity(densityMultiplier);
    }

    public static void setDefaultDisplay(Display display) {
        Shadows.shadowOf(RuntimeEnvironment.application.getResources()).setDisplay(display);
    }

    public void bind(AndroidManifest appManifest) {
        this.appManifest = appManifest;
        if (appManifest != null) {
            this.registerBroadcastReceivers(appManifest);
        }
    }

    private void registerBroadcastReceivers(AndroidManifest androidManifest) {
        for (BroadcastReceiverData receiver : androidManifest.getBroadcastReceivers()) {
            IntentFilter filter = new IntentFilter();
            for (String action : receiver.getActions()) {
                filter.addAction(action);
            }
            String receiverClassName = ShadowApplication.replaceLastDotWith$IfInnerStaticClass(receiver.getClassName());
            this.registerReceiver((BroadcastReceiver)Shadow.newInstanceOf((String)receiverClassName), filter);
        }
    }

    private static String replaceLastDotWith$IfInnerStaticClass(String receiverClassName) {
        String staticInnerClassRegex;
        String[] splits = receiverClassName.split("\\.");
        if (splits[splits.length - 1].matches(staticInnerClassRegex = "[A-Z][a-zA-Z]*") && splits[splits.length - 2].matches(staticInnerClassRegex)) {
            int lastDotIndex = receiverClassName.lastIndexOf(".");
            StringBuilder buffer = new StringBuilder(receiverClassName);
            buffer.setCharAt(lastDotIndex, '$');
            return buffer.toString();
        }
        return receiverClassName;
    }

    public List<Toast> getShownToasts() {
        return this.shownToasts;
    }

    public Scheduler getForegroundThreadScheduler() {
        return RuntimeEnvironment.getMasterScheduler();
    }

    public Scheduler getBackgroundThreadScheduler() {
        return this.backgroundScheduler;
    }

    @Implementation
    public Context getApplicationContext() {
        return this.realApplication;
    }

    @Implementation
    public void startActivity(Intent intent) {
        this.verifyActivityInManifest(intent);
        this.startedActivities.add(intent);
    }

    @Implementation
    public void startActivity(Intent intent, Bundle options) {
        this.verifyActivityInManifest(intent);
        this.startedActivities.add(intent);
    }

    @Implementation
    public ComponentName startService(Intent intent) {
        this.startedServices.add(new Intent.FilterComparison(intent));
        if (intent.getComponent() != null) {
            return intent.getComponent();
        }
        return new ComponentName("some.service.package", "SomeServiceName-FIXME");
    }

    @Implementation
    public boolean stopService(Intent name) {
        this.stoppedServices.add(new Intent.FilterComparison(name));
        return this.startedServices.contains(new Intent.FilterComparison(name));
    }

    public void setComponentNameAndServiceForBindService(ComponentName name, IBinder service) {
        this.defaultServiceConnectionData = new ServiceConnectionDataWrapper(name, service);
    }

    public void setComponentNameAndServiceForBindServiceForIntent(Intent intent, ComponentName name, IBinder service) {
        this.serviceConnectionDataForIntent.put(new Intent.FilterComparison(intent), new ServiceConnectionDataWrapper(name, service));
    }

    @Implementation
    public boolean bindService(final Intent intent, final ServiceConnection serviceConnection, int i) {
        this.boundServiceConnections.add(serviceConnection);
        this.unboundServiceConnections.remove(serviceConnection);
        if (this.unbindableActions.contains(intent.getAction())) {
            return false;
        }
        this.startedServices.add(new Intent.FilterComparison(intent));
        Shadows.shadowOf(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Intent.FilterComparison filterComparison = new Intent.FilterComparison(intent);
                ServiceConnectionDataWrapper serviceConnectionDataWrapper = ShadowApplication.this.serviceConnectionDataForIntent.containsKey(filterComparison) ? (ServiceConnectionDataWrapper)ShadowApplication.this.serviceConnectionDataForIntent.get(filterComparison) : ShadowApplication.this.defaultServiceConnectionData;
                ShadowApplication.this.serviceConnectionDataForServiceConnection.put(serviceConnection, serviceConnectionDataWrapper);
                serviceConnection.onServiceConnected(serviceConnectionDataWrapper.componentNameForBindService, serviceConnectionDataWrapper.binderForBindService);
            }
        }, 0L);
        return true;
    }

    public List<ServiceConnection> getBoundServiceConnections() {
        return this.boundServiceConnections;
    }

    public void setUnbindServiceShouldThrowIllegalArgument(boolean flag) {
        this.unbindServiceShouldThrowIllegalArgument = flag;
    }

    @Implementation
    public void unbindService(final ServiceConnection serviceConnection) {
        if (this.unbindServiceShouldThrowIllegalArgument) {
            throw new IllegalArgumentException();
        }
        this.unboundServiceConnections.add(serviceConnection);
        this.boundServiceConnections.remove(serviceConnection);
        Shadows.shadowOf(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                ServiceConnectionDataWrapper serviceConnectionDataWrapper = ShadowApplication.this.serviceConnectionDataForServiceConnection.containsKey(serviceConnection) ? (ServiceConnectionDataWrapper)ShadowApplication.this.serviceConnectionDataForServiceConnection.get(serviceConnection) : ShadowApplication.this.defaultServiceConnectionData;
                serviceConnection.onServiceDisconnected(serviceConnectionDataWrapper.componentNameForBindService);
            }
        }, 0L);
    }

    public List<ServiceConnection> getUnboundServiceConnections() {
        return this.unboundServiceConnections;
    }

    @Override
    public Intent getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(0);
    }

    @Override
    public Intent peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.get(0);
    }

    @Override
    public Intent getNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.remove(0).getIntent();
    }

    @Override
    public Intent peekNextStartedService() {
        if (this.startedServices.isEmpty()) {
            return null;
        }
        return this.startedServices.get(0).getIntent();
    }

    @Override
    public void clearStartedServices() {
        this.startedServices.clear();
    }

    @Override
    public Intent getNextStoppedService() {
        if (this.stoppedServices.isEmpty()) {
            return null;
        }
        return this.stoppedServices.remove(0).getIntent();
    }

    @Implementation
    public void sendBroadcast(Intent intent) {
        this.sendBroadcastWithPermission(intent, null);
    }

    @Implementation
    public void sendBroadcast(Intent intent, String receiverPermission) {
        this.sendBroadcastWithPermission(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        this.sendOrderedBroadcastWithPermission(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        List<Wrapper> receivers = this.getAppropriateWrappers(intent, receiverPermission);
        this.sortByPriority(receivers);
        receivers.add(new Wrapper(resultReceiver, null, (Context)this.realApplication, null, scheduler));
        this.postOrderedToWrappers(receivers, intent, initialCode, initialData, initialExtras);
    }

    private List<Wrapper> getAppropriateWrappers(Intent intent, String receiverPermission) {
        this.broadcastIntents.add(intent);
        ArrayList<Wrapper> result = new ArrayList<Wrapper>();
        ArrayList<Wrapper> copy = new ArrayList<Wrapper>();
        copy.addAll(this.registeredReceivers);
        for (Wrapper wrapper : copy) {
            int match;
            if (!this.hasMatchingPermission(wrapper.broadcastPermission, receiverPermission) || !wrapper.intentFilter.matchAction(intent.getAction()) || (match = wrapper.intentFilter.matchData(intent.getType(), intent.getScheme(), intent.getData())) == -2 || match == -1) continue;
            result.add(wrapper);
        }
        return result;
    }

    private void postIntent(Intent intent, Wrapper wrapper, final AtomicBoolean abort) {
        Handler scheduler = wrapper.scheduler != null ? wrapper.scheduler : this.getMainHandler();
        final BroadcastReceiver receiver = wrapper.broadcastReceiver;
        final ShadowBroadcastReceiver shReceiver = Shadows.shadowOf(receiver);
        final Intent broadcastIntent = intent;
        scheduler.post(new Runnable(){

            @Override
            public void run() {
                receiver.setPendingResult(ShadowBroadcastPendingResult.create(0, null, null, false));
                shReceiver.onReceive((Context)ShadowApplication.this.realApplication, broadcastIntent, abort);
            }
        });
    }

    private void postToWrappers(List<Wrapper> wrappers, Intent intent) {
        AtomicBoolean abort = new AtomicBoolean(false);
        for (Wrapper wrapper : wrappers) {
            this.postIntent(intent, wrapper, abort);
        }
    }

    private void postOrderedToWrappers(List<Wrapper> wrappers, Intent intent, int initialCode, String data, Bundle extras) {
        AtomicBoolean abort = new AtomicBoolean(false);
        ListenableFuture<BroadcastResultHolder> future = Futures.immediateFuture((Object)new BroadcastResultHolder(initialCode, data, extras));
        for (Wrapper wrapper : wrappers) {
            future = this.postIntent(wrapper, intent, future, abort);
        }
        ListenableFuture<BroadcastResultHolder> finalFuture = future;
        future.addListener(new Runnable((ListenableFuture)finalFuture){
            final /* synthetic */ ListenableFuture val$finalFuture;
            {
                this.val$finalFuture = listenableFuture;
            }

            @Override
            public void run() {
                ShadowApplication.this.getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            val$finalFuture.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }, MoreExecutors.directExecutor());
    }

    private ListenableFuture<BroadcastResultHolder> postIntent(final Wrapper wrapper, final Intent intent, ListenableFuture<BroadcastResultHolder> oldResult, final AtomicBoolean abort) {
        final Handler scheduler = wrapper.scheduler != null ? wrapper.scheduler : this.getMainHandler();
        return Futures.transformAsync(oldResult, (AsyncFunction)new AsyncFunction<BroadcastResultHolder, BroadcastResultHolder>(){

            public ListenableFuture<BroadcastResultHolder> apply(BroadcastResultHolder broadcastResultHolder) throws Exception {
                BroadcastReceiver.PendingResult result = ShadowBroadcastPendingResult.create(broadcastResultHolder.resultCode, broadcastResultHolder.resultData, broadcastResultHolder.resultExtras, true);
                wrapper.broadcastReceiver.setPendingResult(result);
                scheduler.post(new Runnable(){

                    @Override
                    public void run() {
                        Shadows.shadowOf(wrapper.broadcastReceiver).onReceive((Context)ShadowApplication.this.realApplication, intent, abort);
                    }
                });
                return BroadcastResultHolder.transform(result);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void sendBroadcastWithPermission(Intent intent, String receiverPermission) {
        List<Wrapper> wrappers = this.getAppropriateWrappers(intent, receiverPermission);
        this.postToWrappers(wrappers, intent);
    }

    private void sendOrderedBroadcastWithPermission(Intent intent, String receiverPermission) {
        List<Wrapper> wrappers = this.getAppropriateWrappers(intent, receiverPermission);
        this.sortByPriority(wrappers);
        this.postOrderedToWrappers(wrappers, intent, 0, null, null);
    }

    private void sortByPriority(List<Wrapper> wrappers) {
        Collections.sort(wrappers, new Comparator<Wrapper>(){

            @Override
            public int compare(Wrapper o1, Wrapper o2) {
                return Integer.compare(o2.getIntentFilter().getPriority(), o1.getIntentFilter().getPriority());
            }
        });
    }

    @Override
    public List<Intent> getBroadcastIntents() {
        return this.broadcastIntents;
    }

    @Implementation
    public void sendStickyBroadcast(Intent intent) {
        this.stickyIntents.put(intent.getAction(), intent);
        this.sendBroadcast(intent);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.registerReceiverWithContext(receiver, filter, null, null, (Context)this.realApplication);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, (Context)this.realApplication);
    }

    Intent registerReceiverWithContext(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, Context context) {
        if (receiver != null) {
            this.registeredReceivers.add(new Wrapper(receiver, filter, context, broadcastPermission, scheduler));
        }
        return this.processStickyIntents(filter, receiver, context);
    }

    private void verifyActivityInManifest(Intent intent) {
        if (this.checkActivities && this.realApplication.getPackageManager().resolveActivity(intent, -1) == null) {
            throw new ActivityNotFoundException(intent.getAction());
        }
    }

    private Intent processStickyIntents(IntentFilter filter, BroadcastReceiver receiver, Context context) {
        Intent result = null;
        for (Intent stickyIntent : this.stickyIntents.values()) {
            if (!filter.matchAction(stickyIntent.getAction())) continue;
            if (result == null) {
                result = stickyIntent;
            }
            if (receiver != null) {
                receiver.onReceive(context, stickyIntent);
                continue;
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        boolean found = false;
        Iterator<Wrapper> iterator = this.registeredReceivers.iterator();
        while (iterator.hasNext()) {
            Wrapper wrapper = iterator.next();
            if (wrapper.broadcastReceiver != broadcastReceiver) continue;
            iterator.remove();
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Receiver not registered: " + broadcastReceiver);
        }
    }

    public void assertNoBroadcastListenersOfActionRegistered(ContextWrapper context, String action) {
        for (Wrapper registeredReceiver : this.registeredReceivers) {
            if (registeredReceiver.context != context.getBaseContext()) continue;
            Iterator actions = registeredReceiver.intentFilter.actionsIterator();
            while (actions.hasNext()) {
                if (!((String)actions.next()).equals(action)) continue;
                IllegalStateException e = new IllegalStateException("Unexpected BroadcastReceiver on " + context + " with action " + action + " " + registeredReceiver.broadcastReceiver + " that was originally registered here:");
                e.setStackTrace(registeredReceiver.exception.getStackTrace());
                throw e;
            }
        }
    }

    public boolean hasReceiverForIntent(Intent intent) {
        for (Wrapper wrapper : this.registeredReceivers) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            return true;
        }
        return false;
    }

    public List<BroadcastReceiver> getReceiversForIntent(Intent intent) {
        ArrayList<BroadcastReceiver> broadcastReceivers = new ArrayList<BroadcastReceiver>();
        for (Wrapper wrapper : this.registeredReceivers) {
            if (!wrapper.intentFilter.matchAction(intent.getAction())) continue;
            broadcastReceivers.add(wrapper.getBroadcastReceiver());
        }
        return broadcastReceivers;
    }

    public List<Wrapper> getRegisteredReceivers() {
        return this.registeredReceivers;
    }

    public LayoutInflater getLayoutInflater() {
        return this.layoutInflater;
    }

    public AppWidgetManager getAppWidgetManager() {
        return this.appWidgetManager;
    }

    public ShadowAlertDialog getLatestAlertDialog() {
        return this.latestAlertDialog;
    }

    public void setLatestAlertDialog(ShadowAlertDialog latestAlertDialog) {
        this.latestAlertDialog = latestAlertDialog;
    }

    public ShadowDialog getLatestDialog() {
        return this.latestDialog;
    }

    public void setLatestDialog(ShadowDialog latestDialog) {
        this.latestDialog = latestDialog;
    }

    public Object getBluetoothAdapter() {
        return this.bluetoothAdapter;
    }

    public void declareActionUnbindable(String action) {
        this.unbindableActions.add(action);
    }

    public PowerManager.WakeLock getLatestWakeLock() {
        return this.latestWakeLock;
    }

    public void addWakeLock(PowerManager.WakeLock wl) {
        this.latestWakeLock = wl;
    }

    public void clearWakeLocks() {
        this.latestWakeLock = null;
    }

    public AndroidManifest getAppManifest() {
        return this.appManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSingleton(Class<T> clazz, Provider<T> provider) {
        Map<String, Object> map = this.singletons;
        synchronized (map) {
            Object item = this.singletons.get(clazz.getName());
            if (item == null) {
                item = provider.get();
                this.singletons.put(clazz.getName(), item);
            }
            return (T)item;
        }
    }

    public void checkActivities(boolean checkActivities) {
        this.checkActivities = checkActivities;
    }

    public ShadowPopupMenu getLatestPopupMenu() {
        return this.latestPopupMenu;
    }

    public void setLatestPopupMenu(ShadowPopupMenu latestPopupMenu) {
        this.latestPopupMenu = latestPopupMenu;
    }

    public PopupWindow getLatestPopupWindow() {
        return this.latestPopupWindow;
    }

    public void setLatestPopupWindow(PopupWindow latestPopupWindow) {
        this.latestPopupWindow = latestPopupWindow;
    }

    public ListPopupWindow getLatestListPopupWindow() {
        return this.latestListPopupWindow;
    }

    public void setLatestListPopupWindow(ListPopupWindow latestListPopupWindow) {
        this.latestListPopupWindow = latestListPopupWindow;
    }

    @Implementation
    public int checkPermission(String permission, int pid, int uid) {
        return this.grantedPermissions.contains(permission) ? 0 : -1;
    }

    @Override
    public void grantPermissions(String ... permissionNames) {
        Collections.addAll(this.grantedPermissions, permissionNames);
    }

    @Override
    public void denyPermissions(String ... permissionNames) {
        for (String permissionName : permissionNames) {
            this.grantedPermissions.remove(permissionName);
        }
    }

    private boolean hasMatchingPermission(String permission1, String permission2) {
        return permission1 == null ? permission2 == null : permission1.equals(permission2);
    }

    private Handler getMainHandler() {
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(this.realApplication.getMainLooper());
        }
        return this.mainHandler;
    }

    @Deprecated
    public void setSystemService(String key, Object service) {
        ShadowContextImpl shadowContext = (ShadowContextImpl)ShadowExtractor.extract((Object)this.realApplication.getBaseContext());
        shadowContext.setSystemService(key, service);
    }

    private static class ServiceConnectionDataWrapper {
        public final ComponentName componentNameForBindService;
        public final IBinder binderForBindService;

        private ServiceConnectionDataWrapper(ComponentName componentNameForBindService, IBinder binderForBindService) {
            this.componentNameForBindService = componentNameForBindService;
            this.binderForBindService = binderForBindService;
        }
    }

    public class Wrapper {
        public BroadcastReceiver broadcastReceiver;
        public IntentFilter intentFilter;
        public Context context;
        public Throwable exception;
        public String broadcastPermission;
        public Handler scheduler;

        public Wrapper(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, Context context, String broadcastPermission, Handler scheduler) {
            this.broadcastReceiver = broadcastReceiver;
            this.intentFilter = intentFilter;
            this.context = context;
            this.broadcastPermission = broadcastPermission;
            this.scheduler = scheduler;
            this.exception = new Throwable();
        }

        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }

        public IntentFilter getIntentFilter() {
            return this.intentFilter;
        }

        public Context getContext() {
            return this.context;
        }
    }

    private static final class BroadcastResultHolder {
        private final int resultCode;
        private final String resultData;
        private final Bundle resultExtras;

        private BroadcastResultHolder(int resultCode, String resultData, Bundle resultExtras) {
            this.resultCode = resultCode;
            this.resultData = resultData;
            this.resultExtras = resultExtras;
        }

        private static ListenableFuture<BroadcastResultHolder> transform(BroadcastReceiver.PendingResult result) {
            return Futures.transform(Shadows.shadowOf(result).getFuture(), (Function)new Function<BroadcastReceiver.PendingResult, BroadcastResultHolder>(){

                public BroadcastResultHolder apply(BroadcastReceiver.PendingResult pendingResult) {
                    return new BroadcastResultHolder(pendingResult.getResultCode(), pendingResult.getResultData(), pendingResult.getResultExtras(false));
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

