/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AudioManager.class)
public class ShadowAudioManager {
    public static final int MAX_VOLUME_MUSIC_DTMF = 15;
    public static final int DEFAULT_MAX_VOLUME = 7;
    public static final int DEFAULT_VOLUME = 7;
    public static final int INVALID_VOLUME = 0;
    public static final int FLAG_NO_ACTION = 0;
    public static final int[] ALL_STREAMS = new int[]{3, 4, 5, 2, 1, 0, 8};
    private AudioFocusRequest lastAudioFocusRequest;
    private int nextResponseValue = 1;
    private AudioManager.OnAudioFocusChangeListener lastAbandonedAudioFocusListener;
    private HashMap<Integer, AudioStream> streamStatus = new HashMap();
    private int ringerMode = 2;
    private int mode = 0;
    private boolean wiredHeadsetOn;
    private boolean bluetoothA2dpOn;
    private boolean isSpeakerphoneOn;
    private boolean isMicrophoneMuted = false;

    public ShadowAudioManager() {
        for (int stream : ALL_STREAMS) {
            this.streamStatus.put(stream, new AudioStream(7, 7, 0));
        }
        this.streamStatus.get(3).setMaxVolume(15);
        this.streamStatus.get(8).setMaxVolume(15);
    }

    @Implementation
    public int getStreamMaxVolume(int streamType) {
        AudioStream stream = this.streamStatus.get(streamType);
        return stream != null ? stream.getMaxVolume() : 0;
    }

    @Implementation
    public int getStreamVolume(int streamType) {
        AudioStream stream = this.streamStatus.get(streamType);
        return stream != null ? stream.getCurrentVolume() : 0;
    }

    @Implementation
    public void setStreamVolume(int streamType, int index, int flags) {
        AudioStream stream = this.streamStatus.get(streamType);
        if (stream != null) {
            stream.setCurrentVolume(index);
            stream.setFlag(flags);
        }
    }

    @Implementation
    public int requestAudioFocus(AudioManager.OnAudioFocusChangeListener l, int streamType, int durationHint) {
        this.lastAudioFocusRequest = new AudioFocusRequest(l, streamType, durationHint);
        return this.nextResponseValue;
    }

    @Implementation
    public int abandonAudioFocus(AudioManager.OnAudioFocusChangeListener l) {
        this.lastAbandonedAudioFocusListener = l;
        return this.nextResponseValue;
    }

    @Implementation
    public int getRingerMode() {
        return this.ringerMode;
    }

    @Implementation
    public void setRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode((int)ringerMode)) {
            return;
        }
        this.ringerMode = ringerMode;
    }

    public static boolean isValidRingerMode(int ringerMode) {
        return ringerMode >= 0 && ringerMode <= (Integer)ReflectionHelpers.getStaticField(AudioManager.class, (String)"RINGER_MODE_MAX");
    }

    @Implementation
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Implementation
    public int getMode() {
        return this.mode;
    }

    public void setStreamMaxVolume(int streamMaxVolume) {
        for (Map.Entry<Integer, AudioStream> entry : this.streamStatus.entrySet()) {
            entry.getValue().setMaxVolume(streamMaxVolume);
        }
    }

    public void setStreamVolume(int streamVolume) {
        for (Map.Entry<Integer, AudioStream> entry : this.streamStatus.entrySet()) {
            entry.getValue().setCurrentVolume(streamVolume);
        }
    }

    @Implementation
    public void setWiredHeadsetOn(boolean on) {
        this.wiredHeadsetOn = on;
    }

    @Implementation
    public boolean isWiredHeadsetOn() {
        return this.wiredHeadsetOn;
    }

    @Implementation
    public void setBluetoothA2dpOn(boolean on) {
        this.bluetoothA2dpOn = on;
    }

    @Implementation
    public boolean isBluetoothA2dpOn() {
        return this.bluetoothA2dpOn;
    }

    @Implementation
    public void setSpeakerphoneOn(boolean on) {
        this.isSpeakerphoneOn = on;
    }

    @Implementation
    public boolean isSpeakerphoneOn() {
        return this.isSpeakerphoneOn;
    }

    @Implementation
    public void setMicrophoneMute(boolean on) {
        this.isMicrophoneMuted = on;
    }

    @Implementation
    public boolean isMicrophoneMute() {
        return this.isMicrophoneMuted;
    }

    public AudioFocusRequest getLastAudioFocusRequest() {
        return this.lastAudioFocusRequest;
    }

    public void setNextFocusRequestResponse(int nextResponseValue) {
        this.nextResponseValue = nextResponseValue;
    }

    public AudioManager.OnAudioFocusChangeListener getLastAbandonedAudioFocusListener() {
        return this.lastAbandonedAudioFocusListener;
    }

    private static class AudioStream {
        private int currentVolume;
        private int maxVolume;
        private int flag;

        public AudioStream(int currVol, int maxVol, int flag) {
            this.setCurrentVolume(currVol);
            this.setMaxVolume(maxVol);
            this.setFlag(flag);
        }

        public int getCurrentVolume() {
            return this.currentVolume;
        }

        public int getMaxVolume() {
            return this.maxVolume;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setCurrentVolume(int vol) {
            if (vol > this.maxVolume) {
                vol = this.maxVolume;
            } else if (vol < 0) {
                vol = 0;
            }
            this.currentVolume = vol;
        }

        public void setMaxVolume(int vol) {
            this.maxVolume = vol;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }
    }

    public static class AudioFocusRequest {
        public final AudioManager.OnAudioFocusChangeListener listener;
        public final int streamType;
        public final int durationHint;

        private AudioFocusRequest(AudioManager.OnAudioFocusChangeListener listener, int streamType, int durationHint) {
            this.listener = listener;
            this.streamType = streamType;
            this.durationHint = durationHint;
        }
    }
}

