/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.MemoryMappedFile;
import libcore.io.Streams;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.ShadowExtractor;

@Implements(value=MemoryMappedFile.class, isInAndroidSdk=false)
public class ShadowMemoryMappedFile {
    private byte[] bytes;
    private static final String TZ_DATA_1 = "/misc/zoneinfo/tzdata";
    private static final String TZ_DATA_2 = "/usr/share/zoneinfo/tzdata";
    private static final String TZ_DATA_3 = "/misc/zoneinfo/current/tzdata";

    @Implementation
    public static MemoryMappedFile mmapRO(String path) throws Throwable {
        if (path.endsWith(TZ_DATA_1) || path.endsWith(TZ_DATA_2) || path.endsWith(TZ_DATA_3)) {
            InputStream is = MemoryMappedFile.class.getResourceAsStream(TZ_DATA_2);
            if (is == null) {
                throw (Throwable)ShadowMemoryMappedFile.exceptionClass().getConstructor(String.class, Integer.TYPE).newInstance("open", -1);
            }
            try {
                MemoryMappedFile memoryMappedFile = new MemoryMappedFile(-1L, -1L);
                ShadowMemoryMappedFile shadowMemoryMappedFile = (ShadowMemoryMappedFile)ShadowExtractor.extract((Object)memoryMappedFile);
                shadowMemoryMappedFile.bytes = Streams.readFully((InputStream)is);
                return memoryMappedFile;
            }
            catch (IOException e) {
                throw (Throwable)ShadowMemoryMappedFile.exceptionClass().getConstructor(String.class, Integer.TYPE, Throwable.class).newInstance("mmap", -1, e);
            }
        }
        throw new IllegalArgumentException("Unknown file for mmap: '" + path);
    }

    private static Class exceptionClass() {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return ErrnoException.class;
        }
        try {
            return MemoryMappedFile.class.getClassLoader().loadClass("libcore.io.ErrnoException");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public synchronized void close() throws Exception {
        this.bytes = null;
    }

    @Implementation
    public BufferIterator bigEndianIterator() {
        return this.getHeapBufferIterator(ByteOrder.BIG_ENDIAN);
    }

    @Implementation
    public BufferIterator littleEndianIterator() {
        return this.getHeapBufferIterator(ByteOrder.LITTLE_ENDIAN);
    }

    private BufferIterator getHeapBufferIterator(ByteOrder endianness) {
        return new RoboBufferIterator(this.bytes, endianness);
    }

    @Implementation
    public long size() {
        return this.bytes.length;
    }

    private static class RoboBufferIterator
    extends BufferIterator {
        private final ByteBuffer buffer;

        public RoboBufferIterator(byte[] buffer, ByteOrder order) {
            this.buffer = ByteBuffer.wrap(buffer);
        }

        public void seek(int offset) {
            this.buffer.position(offset);
        }

        public void skip(int byteCount) {
            this.buffer.position(this.buffer.position() + byteCount);
        }

        public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
            System.arraycopy(this.buffer.array(), this.buffer.position(), dst, dstOffset, byteCount);
            this.skip(byteCount);
        }

        public byte readByte() {
            return this.buffer.get();
        }

        public int readInt() {
            return this.buffer.getInt();
        }

        public void readIntArray(int[] dst, int dstOffset, int intCount) {
            for (int i = 0; i < intCount; ++i) {
                dst[dstOffset + i] = this.buffer.getInt();
            }
        }

        public short readShort() {
            return this.buffer.getShort();
        }
    }
}

