/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ResourceHelper;

@Implements(value=Notification.class)
public class ShadowNotification {
    @RealObject
    Notification realNotification;

    public CharSequence getContentTitle() {
        return this.findText(this.applyContentView(), "title");
    }

    public CharSequence getContentText() {
        return this.findText(this.applyContentView(), "text");
    }

    public CharSequence getContentInfo() {
        String resourceName = RuntimeEnvironment.getApiLevel() >= 24 ? "header_text" : "info";
        return this.findText(this.applyContentView(), resourceName);
    }

    public boolean isOngoing() {
        return (this.realNotification.flags & 2) == 2;
    }

    public CharSequence getBigText() {
        return this.findText(this.applyBigContentView(), "big_text");
    }

    public CharSequence getBigContentTitle() {
        return this.findText(this.applyBigContentView(), "title");
    }

    public CharSequence getBigContentText() {
        String resourceName = RuntimeEnvironment.getApiLevel() >= 24 ? "header_text" : "text";
        return this.findText(this.applyBigContentView(), resourceName);
    }

    public Bitmap getBigPicture() {
        ImageView imageView = (ImageView)this.applyBigContentView().findViewById(ResourceHelper.getInternalResourceId((String)"big_picture"));
        return imageView != null && imageView.getDrawable() != null ? ((BitmapDrawable)imageView.getDrawable()).getBitmap() : null;
    }

    public boolean isWhenShown() {
        return this.findView(this.applyContentView(), "chronometer").getVisibility() == 0 || this.findView(this.applyContentView(), "time").getVisibility() == 0;
    }

    public ProgressBar getProgressBar() {
        return (ProgressBar)this.findView(this.applyContentView(), "progress");
    }

    public boolean usesChronometer() {
        return this.findView(this.applyContentView(), "chronometer").getVisibility() == 0;
    }

    private View applyContentView() {
        return this.realNotification.contentView.apply((Context)RuntimeEnvironment.application, (ViewGroup)new FrameLayout((Context)RuntimeEnvironment.application));
    }

    private View applyBigContentView() {
        return this.realNotification.bigContentView.apply((Context)RuntimeEnvironment.application, (ViewGroup)new FrameLayout((Context)RuntimeEnvironment.application));
    }

    private CharSequence findText(View view, String resourceName) {
        TextView textView = (TextView)this.findView(view, resourceName);
        return textView.getText();
    }

    private View findView(View view, String resourceName) {
        View subView = view.findViewById(ResourceHelper.getInternalResourceId((String)resourceName));
        if (subView == null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            Shadows.shadowOf(view).dump(new PrintStream(buf), 4);
            throw new IllegalArgumentException("no id." + resourceName + " found in view:\n" + buf.toString());
        }
        return subView;
    }
}

