/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Camera;
import android.view.SurfaceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;

@Implements(value=Camera.class)
public class ShadowCamera {
    private static int lastOpenedCameraId;
    private int id;
    private boolean locked;
    private boolean previewing;
    private boolean released;
    private Camera.Parameters parameters;
    private Camera.PreviewCallback previewCallback;
    private List<byte[]> callbackBuffers = new ArrayList<byte[]>();
    private SurfaceHolder surfaceHolder;
    private int displayOrientation;
    private Camera.AutoFocusCallback autoFocusCallback;
    private boolean autoFocusing;
    private static Map<Integer, Camera.CameraInfo> cameras;
    @RealObject
    private Camera realCamera;

    public void __constructor__() {
        this.locked = true;
        this.previewing = false;
        this.released = false;
    }

    @Implementation
    public static Camera open() {
        lastOpenedCameraId = 0;
        Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
        Shadows.shadowOf((Camera)camera).id = 0;
        return camera;
    }

    @Implementation
    public static Camera open(int cameraId) {
        lastOpenedCameraId = cameraId;
        Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
        Shadows.shadowOf((Camera)camera).id = cameraId;
        return camera;
    }

    public static int getLastOpenedCameraId() {
        return lastOpenedCameraId;
    }

    @Implementation
    public void unlock() {
        this.locked = false;
    }

    @Implementation
    public void reconnect() {
        this.locked = true;
    }

    @Implementation
    public Camera.Parameters getParameters() {
        if (null == this.parameters) {
            this.parameters = (Camera.Parameters)Shadow.newInstanceOf(Camera.Parameters.class);
        }
        return this.parameters;
    }

    @Implementation
    public void setParameters(Camera.Parameters params) {
        this.parameters = params;
    }

    @Implementation
    public void setPreviewDisplay(SurfaceHolder holder) {
        this.surfaceHolder = holder;
    }

    @Implementation
    public void startPreview() {
        this.previewing = true;
    }

    @Implementation
    public void stopPreview() {
        this.previewing = false;
    }

    @Implementation
    public void release() {
        this.released = true;
    }

    @Implementation
    public void setPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    public void setOneShotPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    public void setPreviewCallbackWithBuffer(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    public void invokePreviewCallback(byte[] data) {
        if (this.previewCallback != null) {
            this.previewCallback.onPreviewFrame(data, this.realCamera);
        }
    }

    @Implementation
    public void addCallbackBuffer(byte[] callbackBuffer) {
        this.callbackBuffers.add(callbackBuffer);
    }

    public List<byte[]> getAddedCallbackBuffers() {
        return Collections.unmodifiableList(this.callbackBuffers);
    }

    @Implementation
    public void setDisplayOrientation(int degrees) {
        this.displayOrientation = degrees;
        if (cameras.containsKey(this.id)) {
            ShadowCamera.cameras.get((Object)Integer.valueOf((int)this.id)).orientation = degrees;
        }
    }

    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    @Implementation
    public void autoFocus(Camera.AutoFocusCallback callback) {
        this.autoFocusCallback = callback;
        this.autoFocusing = true;
    }

    @Implementation
    public void cancelAutoFocus() {
        this.autoFocusCallback = null;
        this.autoFocusing = false;
    }

    public boolean hasRequestedAutoFocus() {
        return this.autoFocusing;
    }

    public void invokeAutoFocusCallback(boolean success, Camera camera) {
        if (this.autoFocusCallback == null) {
            throw new IllegalStateException("cannot invoke AutoFocusCallback before autoFocus() has been called or after cancelAutoFocus() has been called or after the callback has been invoked.");
        }
        this.autoFocusCallback.onAutoFocus(success, camera);
        this.autoFocusCallback = null;
        this.autoFocusing = false;
    }

    @Implementation
    public static void getCameraInfo(int cameraId, Camera.CameraInfo cameraInfo) {
        Camera.CameraInfo foundCam = cameras.get(cameraId);
        cameraInfo.facing = foundCam.facing;
        cameraInfo.orientation = foundCam.orientation;
    }

    @Implementation
    public static int getNumberOfCameras() {
        return cameras.size();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isPreviewing() {
        return this.previewing;
    }

    public boolean isReleased() {
        return this.released;
    }

    public SurfaceHolder getPreviewDisplay() {
        return this.surfaceHolder;
    }

    public static void addCameraInfo(int id2, Camera.CameraInfo camInfo) {
        cameras.put(id2, camInfo);
    }

    public static void clearCameraInfo() {
        cameras.clear();
    }

    static {
        cameras = new HashMap<Integer, Camera.CameraInfo>();
    }

    @Implements(value=Camera.Size.class)
    public static class ShadowSize {
        @RealObject
        private Camera.Size realCameraSize;

        public void __constructor__(Camera camera, int width, int height) {
            this.realCameraSize.width = width;
            this.realCameraSize.height = height;
        }
    }

    @Implements(value=Camera.Parameters.class)
    public static class ShadowParameters {
        private int pictureWidth = 1280;
        private int pictureHeight = 960;
        private int previewWidth = 640;
        private int previewHeight = 480;
        private int previewFormat = 17;
        private int previewFpsMin = 10;
        private int previewFpsMax = 30;
        private int previewFps = 30;
        private int exposureCompensation = 0;
        private String focusMode;
        private List<String> supportedFocusModes = new ArrayList<String>();

        @Implementation
        public Camera.Size getPictureSize() {
            Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
            camera.getClass();
            Camera.Size pictureSize = new Camera.Size(camera, 0, 0);
            pictureSize.width = this.pictureWidth;
            pictureSize.height = this.pictureHeight;
            return pictureSize;
        }

        @Implementation
        public int getPreviewFormat() {
            return this.previewFormat;
        }

        @Implementation
        public void getPreviewFpsRange(int[] range) {
            range[0] = this.previewFpsMin;
            range[1] = this.previewFpsMax;
        }

        @Implementation
        public int getPreviewFrameRate() {
            return this.previewFps;
        }

        @Implementation
        public Camera.Size getPreviewSize() {
            Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
            camera.getClass();
            Camera.Size previewSize = new Camera.Size(camera, 0, 0);
            previewSize.width = this.previewWidth;
            previewSize.height = this.previewHeight;
            return previewSize;
        }

        @Implementation
        public List<Camera.Size> getSupportedPictureSizes() {
            ArrayList<Camera.Size> supportedSizes = new ArrayList<Camera.Size>();
            this.addSize(supportedSizes, 320, 240);
            this.addSize(supportedSizes, 640, 480);
            this.addSize(supportedSizes, 800, 600);
            return supportedSizes;
        }

        @Implementation
        public List<Integer> getSupportedPictureFormats() {
            ArrayList<Integer> formats = new ArrayList<Integer>();
            formats.add(17);
            formats.add(256);
            return formats;
        }

        @Implementation
        public List<Integer> getSupportedPreviewFormats() {
            ArrayList<Integer> formats = new ArrayList<Integer>();
            formats.add(17);
            formats.add(256);
            return formats;
        }

        @Implementation
        public List<int[]> getSupportedPreviewFpsRange() {
            ArrayList<int[]> supportedRanges = new ArrayList<int[]>();
            this.addRange(supportedRanges, 15000, 15000);
            this.addRange(supportedRanges, 10000, 30000);
            return supportedRanges;
        }

        @Implementation
        public List<Integer> getSupportedPreviewFrameRates() {
            ArrayList<Integer> supportedRates = new ArrayList<Integer>();
            supportedRates.add(10);
            supportedRates.add(15);
            supportedRates.add(30);
            return supportedRates;
        }

        @Implementation
        public List<Camera.Size> getSupportedPreviewSizes() {
            ArrayList<Camera.Size> supportedSizes = new ArrayList<Camera.Size>();
            this.addSize(supportedSizes, 320, 240);
            this.addSize(supportedSizes, 640, 480);
            return supportedSizes;
        }

        public void setSupportedFocusModes(String ... focusModes) {
            this.supportedFocusModes = Arrays.asList(focusModes);
        }

        @Implementation
        public List<String> getSupportedFocusModes() {
            return this.supportedFocusModes;
        }

        @Implementation
        public String getFocusMode() {
            return this.focusMode;
        }

        @Implementation
        public void setFocusMode(String focusMode) {
            this.focusMode = focusMode;
        }

        @Implementation
        public void setPictureSize(int width, int height) {
            this.pictureWidth = width;
            this.pictureHeight = height;
        }

        @Implementation
        public void setPreviewFormat(int pixel_format) {
            this.previewFormat = pixel_format;
        }

        @Implementation
        public void setPreviewFpsRange(int min, int max) {
            this.previewFpsMin = min;
            this.previewFpsMax = max;
        }

        @Implementation
        public void setPreviewFrameRate(int fps) {
            this.previewFps = fps;
        }

        @Implementation
        public void setPreviewSize(int width, int height) {
            this.previewWidth = width;
            this.previewHeight = height;
        }

        @Implementation
        public int getMinExposureCompensation() {
            return -6;
        }

        @Implementation
        public int getMaxExposureCompensation() {
            return 6;
        }

        @Implementation
        public float getExposureCompensationStep() {
            return 0.5f;
        }

        @Implementation
        public int getExposureCompensation() {
            return this.exposureCompensation;
        }

        @Implementation
        public void setExposureCompensation(int compensation) {
            this.exposureCompensation = compensation;
        }

        public int getPreviewWidth() {
            return this.previewWidth;
        }

        public int getPreviewHeight() {
            return this.previewHeight;
        }

        public int getPictureWidth() {
            return this.pictureWidth;
        }

        public int getPictureHeight() {
            return this.pictureHeight;
        }

        private void addSize(List<Camera.Size> sizes, int width, int height) {
            Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
            camera.getClass();
            Camera.Size newSize = new Camera.Size(camera, 0, 0);
            newSize.width = width;
            newSize.height = height;
            sizes.add(newSize);
        }

        private void addRange(List<int[]> ranges, int min, int max) {
            int[] range = new int[]{min, max};
            ranges.add(range);
        }
    }
}

