/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.IAccountManager;
import android.app.admin.IDevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.print.IPrintManager;
import android.view.Display;
import android.view.accessibility.AccessibilityManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.RoboSharedPreferences;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.RoboLayoutInflater;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.app.ContextImpl")
public class ShadowContextImpl {
    public static final String CLASS_NAME = "android.app.ContextImpl";
    private static final Map<String, String> SYSTEM_SERVICE_MAP = new HashMap<String, String>();
    private final Map<String, RoboSharedPreferences> roboSharedPreferencesMap = new HashMap<String, RoboSharedPreferences>();
    private Map<String, Map<String, Object>> sharedPreferenceMap = new HashMap<String, Map<String, Object>>();
    private ContentResolver contentResolver;
    @RealObject
    private Context realObject;
    private Map<String, Object> systemServices = new HashMap<String, Object>();

    @Implementation
    public Object getSystemService(String name) {
        if (name.equals("layout_inflater")) {
            return new RoboLayoutInflater((Context)RuntimeEnvironment.application);
        }
        Object service = this.systemServices.get(name);
        if (service == null) {
            String serviceClassName = SYSTEM_SERVICE_MAP.get(name);
            if (serviceClassName == null) {
                System.err.println("WARNING: unknown service " + name);
                return null;
            }
            try {
                Class<?> clazz = Class.forName(serviceClassName);
                if (serviceClassName.equals("android.app.admin.DevicePolicyManager")) {
                    service = RuntimeEnvironment.getApiLevel() >= 24 ? ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(IDevicePolicyManager.class, null), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)}) : ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(Handler.class, null)});
                } else if (serviceClassName.equals("android.app.SearchManager") || serviceClassName.equals("android.app.ActivityManager") || serviceClassName.equals("android.app.WallpaperManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(Handler.class, null)});
                } else if (serviceClassName.equals("android.os.storage.StorageManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                } else if (serviceClassName.equals("android.nfc.NfcManager") || serviceClassName.equals("android.telecom.TelecomManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application)});
                } else if (serviceClassName.equals("android.hardware.display.DisplayManager") || serviceClassName.equals("android.telephony.SubscriptionManager")) {
                    service = ReflectionHelpers.callConstructor(clazz, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application)});
                } else if (serviceClassName.equals("android.view.accessibility.AccessibilityManager")) {
                    service = AccessibilityManager.getInstance((Context)this.realObject);
                } else if (RuntimeEnvironment.getApiLevel() >= 17 && serviceClassName.equals("android.view.WindowManagerImpl")) {
                    Class<?> windowMgrImplClass = Class.forName("android.view.WindowManagerImpl");
                    if (RuntimeEnvironment.getApiLevel() >= 24) {
                        service = ReflectionHelpers.callConstructor(windowMgrImplClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)this.realObject)});
                    } else {
                        Display display = (Display)Shadow.newInstanceOf(Display.class);
                        service = ReflectionHelpers.callConstructor(windowMgrImplClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Display.class, (Object)display)});
                    }
                } else {
                    service = serviceClassName.equals("android.accounts.AccountManager") ? ReflectionHelpers.callConstructor(Class.forName("android.accounts.AccountManager"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(IAccountManager.class, null)}) : (serviceClassName.equals("android.net.wifi.p2p.WifiP2pManager") ? new WifiP2pManager((IWifiP2pManager)ReflectionHelpers.createNullProxy(IWifiP2pManager.class)) : (RuntimeEnvironment.getApiLevel() >= 19 && serviceClassName.equals("android.print.PrintManager") ? ReflectionHelpers.callConstructor(Class.forName("android.print.PrintManager"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(IPrintManager.class, null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)-1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)-1)}) : Shadow.newInstanceOf(clazz)));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            this.systemServices.put(name, service);
        }
        return service;
    }

    public void setSystemService(String key, Object service) {
        this.systemServices.put(key, service);
    }

    @Implementation
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        intent.sendIntent(this.realObject, 0, fillInIntent, null, null, null);
    }

    @Implementation
    public ComponentName startService(Intent service) {
        return ShadowApplication.getInstance().startService(service);
    }

    @Implementation
    public void startActivity(Intent intent) {
        ShadowApplication.getInstance().startActivity(intent);
    }

    @Implementation
    public void sendBroadcast(Intent intent) {
        ShadowApplication.getInstance().sendBroadcast(intent);
    }

    @Implementation
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Implementation
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return ShadowApplication.getInstance().bindService(intent, serviceConnection, i);
    }

    @Implementation
    public void unbindService(ServiceConnection serviceConnection) {
        ShadowApplication.getInstance().unbindService(serviceConnection);
    }

    @Implementation
    public int checkCallingPermission(String permission) {
        return this.checkPermission(permission, -1, -1);
    }

    @Implementation
    public int checkCallingOrSelfPermission(String permission) {
        return this.checkPermission(permission, -1, -1);
    }

    @Implementation
    public ContentResolver getContentResolver() {
        if (this.contentResolver == null) {
            this.contentResolver = new ContentResolver(this.realObject){

                protected IContentProvider acquireProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseProvider(IContentProvider icp) {
                    return false;
                }

                protected IContentProvider acquireUnstableProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseUnstableProvider(IContentProvider icp) {
                    return false;
                }

                public void unstableProviderDied(IContentProvider icp) {
                }
            };
        }
        return this.contentResolver;
    }

    @Implementation
    public void sendBroadcast(Intent intent, String receiverPermission) {
        ShadowApplication.getInstance().sendBroadcast(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        ShadowApplication.getInstance().sendOrderedBroadcast(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        ShadowApplication.getInstance().sendOrderedBroadcast(intent, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Implementation
    public void sendStickyBroadcast(Intent intent) {
        ShadowApplication.getInstance().sendStickyBroadcast(intent);
    }

    @Implementation
    public int checkPermission(String permission, int pid, int uid) {
        return ShadowApplication.getInstance().checkPermission(permission, pid, uid);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return ShadowApplication.getInstance().registerReceiverWithContext(receiver, filter, null, null, this.realObject);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return ShadowApplication.getInstance().registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, this.realObject);
    }

    @Implementation
    public Intent registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return ShadowApplication.getInstance().registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, this.realObject);
    }

    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        ShadowApplication.getInstance().unregisterReceiver(broadcastReceiver);
    }

    @Implementation
    public boolean stopService(Intent name) {
        return ShadowApplication.getInstance().stopService(name);
    }

    @Implementation
    public void startActivity(Intent intent, Bundle options) {
        ShadowApplication.getInstance().startActivity(intent, options);
    }

    @Implementation
    public void startActivities(Intent[] intents) {
        for (int i = intents.length - 1; i >= 0; --i) {
            this.startActivity(intents[i]);
        }
    }

    @Implementation
    public void startActivities(Intent[] intents, Bundle options) {
        for (int i = intents.length - 1; i >= 0; --i) {
            this.startActivity(intents[i], options);
        }
    }

    @Implementation
    public SharedPreferences getSharedPreferences(String name, int mode) {
        if (!this.roboSharedPreferencesMap.containsKey(name)) {
            this.roboSharedPreferencesMap.put(name, new RoboSharedPreferences(this.sharedPreferenceMap, name, mode));
        }
        return this.roboSharedPreferencesMap.get(name);
    }

    @Implementation
    public int getUserId() {
        return 0;
    }

    @Implementation
    public File getExternalCacheDir() {
        return Environment.getExternalStorageDirectory();
    }

    @Implementation(maxSdk=18)
    public File getExternalFilesDir(String type) {
        return Environment.getExternalStoragePublicDirectory((String)type);
    }

    @Implementation(minSdk=19)
    public File[] getExternalFilesDirs(String type) {
        return new File[]{Environment.getExternalStoragePublicDirectory((String)type)};
    }

    static {
        SYSTEM_SERVICE_MAP.put("window", "android.view.WindowManagerImpl");
        SYSTEM_SERVICE_MAP.put("clipboard", "android.content.ClipboardManager");
        SYSTEM_SERVICE_MAP.put("sensor", "org.robolectric.fakes.RoboSensorManager");
        SYSTEM_SERVICE_MAP.put("vibrator", "org.robolectric.fakes.RoboVibrator");
        SYSTEM_SERVICE_MAP.put("layout_inflater", "android.view.LayoutInflater");
        SYSTEM_SERVICE_MAP.put("activity", "android.app.ActivityManager");
        SYSTEM_SERVICE_MAP.put("power", "android.os.PowerManager");
        SYSTEM_SERVICE_MAP.put("alarm", "android.app.AlarmManager");
        SYSTEM_SERVICE_MAP.put("notification", "android.app.NotificationManager");
        SYSTEM_SERVICE_MAP.put("keyguard", "android.app.KeyguardManager");
        SYSTEM_SERVICE_MAP.put("location", "android.location.LocationManager");
        SYSTEM_SERVICE_MAP.put("search", "android.app.SearchManager");
        SYSTEM_SERVICE_MAP.put("storage", "android.os.storage.StorageManager");
        SYSTEM_SERVICE_MAP.put("connectivity", "android.net.ConnectivityManager");
        SYSTEM_SERVICE_MAP.put("wifi", "android.net.wifi.WifiManager");
        SYSTEM_SERVICE_MAP.put("audio", "android.media.AudioManager");
        SYSTEM_SERVICE_MAP.put("phone", "android.telephony.TelephonyManager");
        SYSTEM_SERVICE_MAP.put("input_method", "android.view.inputmethod.InputMethodManager");
        SYSTEM_SERVICE_MAP.put("uimode", "android.app.UiModeManager");
        SYSTEM_SERVICE_MAP.put("download", "android.app.DownloadManager");
        SYSTEM_SERVICE_MAP.put("textservices", "android.view.textservice.TextServicesManager");
        SYSTEM_SERVICE_MAP.put("device_policy", "android.app.admin.DevicePolicyManager");
        SYSTEM_SERVICE_MAP.put("dropbox", "android.os.DropBoxManager");
        SYSTEM_SERVICE_MAP.put("media_router", "android.media.MediaRouter");
        SYSTEM_SERVICE_MAP.put("accessibility", "android.view.accessibility.AccessibilityManager");
        SYSTEM_SERVICE_MAP.put("account", "android.accounts.AccountManager");
        SYSTEM_SERVICE_MAP.put("nfc", "android.nfc.NfcManager");
        SYSTEM_SERVICE_MAP.put("wallpaper", "android.app.WallpaperManager");
        SYSTEM_SERVICE_MAP.put("wifip2p", "android.net.wifi.p2p.WifiP2pManager");
        if (RuntimeEnvironment.getApiLevel() >= 17) {
            SYSTEM_SERVICE_MAP.put("display", "android.hardware.display.DisplayManager");
            SYSTEM_SERVICE_MAP.put("user", "android.os.UserManager");
        }
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            SYSTEM_SERVICE_MAP.put("bluetooth", "android.bluetooth.BluetoothManager");
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            SYSTEM_SERVICE_MAP.put("print", "android.print.PrintManager");
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            SYSTEM_SERVICE_MAP.put("jobscheduler", "android.app.JobSchedulerImpl");
            SYSTEM_SERVICE_MAP.put("telecom", "android.telecom.TelecomManager");
            SYSTEM_SERVICE_MAP.put("media_session", "android.media.session.MediaSessionManager");
        }
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            SYSTEM_SERVICE_MAP.put("telephony_subscription_service", "android.telephony.SubscriptionManager");
        }
    }
}

