/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.PowerManager;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=PowerManager.class)
public class ShadowPowerManager {
    private boolean isScreenOn = true;
    private boolean isInteractive = true;
    private boolean isPowerSaveMode = false;
    private Map<Integer, Boolean> supportedWakeLockLevels = new HashMap<Integer, Boolean>();

    @Implementation
    public PowerManager.WakeLock newWakeLock(int flags, String tag) {
        PowerManager.WakeLock wl = (PowerManager.WakeLock)Shadow.newInstanceOf(PowerManager.WakeLock.class);
        ShadowApplication.getInstance().addWakeLock(wl);
        return wl;
    }

    @Implementation
    public boolean isScreenOn() {
        return this.isScreenOn;
    }

    public void setIsScreenOn(boolean screenOn) {
        this.isScreenOn = screenOn;
    }

    @Implementation(minSdk=20)
    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setIsInteractive(boolean interactive) {
        this.isInteractive = interactive;
    }

    @Implementation(minSdk=20)
    public boolean isPowerSaveMode() {
        return this.isPowerSaveMode;
    }

    public void setIsPowerSaveMode(boolean powerSaveMode) {
        this.isPowerSaveMode = powerSaveMode;
    }

    @Implementation(minSdk=21)
    public boolean isWakeLockLevelSupported(int level) {
        return this.supportedWakeLockLevels.containsKey(level) ? this.supportedWakeLockLevels.get(level) : false;
    }

    public void setIsWakeLockLevelSupported(int level, boolean supported) {
        this.supportedWakeLockLevels.put(level, supported);
    }

    @Resetter
    public static void reset() {
        ShadowApplication shadowApplication = ShadowApplication.getInstance();
        if (shadowApplication != null) {
            shadowApplication.clearWakeLocks();
        }
    }

    public static PowerManager.WakeLock getLatestWakeLock() {
        return Shadows.shadowOf(RuntimeEnvironment.application).getLatestWakeLock();
    }

    @Implements(value=PowerManager.WakeLock.class)
    public static class ShadowWakeLock {
        private boolean refCounted = true;
        private int refCount;
        private boolean locked;

        @Implementation
        public void acquire() {
            this.acquire(0L);
        }

        @Implementation
        public synchronized void acquire(long timeout) {
            if (this.refCounted) {
                ++this.refCount;
            } else {
                this.locked = true;
            }
        }

        @Implementation
        public synchronized void release() {
            if (this.refCounted) {
                if (--this.refCount < 0) {
                    throw new RuntimeException("WakeLock under-locked");
                }
            } else {
                this.locked = false;
            }
        }

        @Implementation
        public synchronized boolean isHeld() {
            return this.refCounted ? this.refCount > 0 : this.locked;
        }

        public boolean isReferenceCounted() {
            return this.refCounted;
        }

        @Implementation
        public void setReferenceCounted(boolean value) {
            this.refCounted = value;
        }
    }
}

