/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SensorManager.class)
public class ShadowSensorManager {
    public boolean forceListenersToFail = false;
    private final Map<Integer, Sensor> sensorMap = new HashMap<Integer, Sensor>();
    private final ArrayList<SensorEventListener> listeners = new ArrayList();

    public void addSensor(int sensorType, Sensor sensor) {
        this.sensorMap.put(sensorType, sensor);
    }

    @Implementation
    public Sensor getDefaultSensor(int type) {
        return this.sensorMap.get(type);
    }

    @Implementation
    public boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        if (this.forceListenersToFail) {
            return false;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return true;
    }

    @Implementation
    public void unregisterListener(SensorEventListener listener, Sensor sensor) {
        this.listeners.remove(listener);
    }

    @Implementation
    public void unregisterListener(SensorEventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasListener(SensorEventListener listener) {
        return this.listeners.contains(listener);
    }

    public SensorEvent createSensorEvent() {
        return (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }
}

