/*
 * Decompiled with CFR 0.152.
 */
package scala.scalajs.niocharset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.scalajs.niocharset.UTF_16_Common$;

@ScalaSignature(bytes="\u0006\u0001\u00055cA\u0002\u0011\"\u0003\u0003\ts\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u00035\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011B#\t\u0011%\u0003!\u0011!Q\u0001\n\u0019CQA\u0013\u0001\u0005\u0012-CQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0017\u0001\u0005\u0002eCQ!\u0018\u0001\u0005\u0002y3AA\u0019\u0001\u0005G\")!*\u0003C\u0001I\"aq-\u0003C\u0001\u0002\u000b\u0005\t\u0019!C\u0005\u000b\"a\u0001.\u0003C\u0001\u0002\u000b\u0005\t\u0019!C\u0005S\"Iq.\u0003B\u0001\u0002\u0003\u0006KA\u0012\u0005\u0006a&!\t&\u001d\u0005\u0006e&!\ta\u001d\u0004\u0007\u0003\u000b\u0001A!a\u0002\t\r)\u0003B\u0011AA\u0005\u0011%\ti\u0001\u0005a\u0001\n\u0013\ty\u0001C\u0005\u0002\u0012A\u0001\r\u0011\"\u0003\u0002\u0014!9\u0011q\u0003\t!B\u0013\u0019\u0006\"\u00029\u0011\t#\n\bbBA\r!\u0011\u0005\u00111D\u0004\t\u0003C\t\u0003\u0012A\u0011\u0002$\u00199\u0001%\tE\u0001C\u0005\u0015\u0002B\u0002&\u0019\t\u0003\ti\u0003C\u0005\u00020a\u0011\r\u0011\"\u0002\u00022!A\u0011q\u0007\r!\u0002\u001b\t\u0019\u0004C\u0005\u0002:a\u0011\r\u0011\"\u0002\u0002<!A\u0011\u0011\t\r!\u0002\u001b\ti\u0004C\u0005\u0002Da\u0011\r\u0011\"\u0002\u0002F!A\u00111\n\r!\u0002\u001b\t9EA\u0007V)\u001a{\u0016GN0D_6lwN\u001c\u0006\u0003E\r\n!B\\5pG\"\f'o]3u\u0015\t!S%A\u0004tG\u0006d\u0017M[:\u000b\u0003\u0019\nQa]2bY\u0006\u001c\"\u0001\u0001\u0015\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013aB2iCJ\u001cX\r\u001e\u0006\u0003[9\n1A\\5p\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0016\u0003\u000f\rC\u0017M]:fi\u0006!a.Y7f\u0007\u0001\u0001\"!\u000e\u001f\u000f\u0005YR\u0004CA\u001c&\u001b\u0005A$BA\u001d4\u0003\u0019a$o\\8u}%\u00111(J\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<K\u00059\u0011\r\\5bg\u0016\u001c\bcA!Ci5\tQ%\u0003\u0002DK\t)\u0011I\u001d:bs\u0006QQM\u001c3jC:tWm]:\u0016\u0003\u0019\u0003\"!Q$\n\u0005!+#aA%oi\u0006YQM\u001c3jC:tWm]:!\u0003\u0019a\u0014N\\5u}Q!AJT(Q!\ti\u0005!D\u0001\"\u0011\u0015\u0011T\u00011\u00015\u0011\u0015yT\u00011\u0001A\u0011\u0015!U\u00011\u0001G\u0003!\u0019wN\u001c;bS:\u001cHCA*W!\t\tE+\u0003\u0002VK\t9!i\\8mK\u0006t\u0007\"B,\u0007\u0001\u0004A\u0013\u0001\u0002;iCR\f!B\\3x\t\u0016\u001cw\u000eZ3s)\u0005Q\u0006CA\u0015\\\u0013\ta&F\u0001\bDQ\u0006\u00148/\u001a;EK\u000e|G-\u001a:\u0002\u00159,w/\u00128d_\u0012,'\u000fF\u0001`!\tI\u0003-\u0003\u0002bU\tq1\t[1sg\u0016$XI\\2pI\u0016\u0014(a\u0002#fG>$WM]\n\u0003\u0013i#\u0012!\u001a\t\u0003M&i\u0011\u0001A\u0001;g\u000e\fG.\u0019\u0013tG\u0006d\u0017M[:%]&|7\r[1sg\u0016$H%\u0016+G?F2tlQ8n[>tG\u0005R3d_\u0012,'\u000f\n\u0013f]\u0012L\u0017M\u001c8fgN\fah]2bY\u0006$3oY1mC*\u001cHE\\5pG\"\f'o]3uIU#fiX\u00197?\u000e{W.\\8oI\u0011+7m\u001c3fe\u0012\"SM\u001c3jC:tWm]:`I\u0015\fHC\u00016n!\t\t5.\u0003\u0002mK\t!QK\\5u\u0011\u001dqG\"!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003m\u001a8-\u00197bIM\u001c\u0017\r\\1kg\u0012r\u0017n\\2iCJ\u001cX\r\u001e\u0013V)\u001a{\u0016GN0D_6lwN\u001c\u0013EK\u000e|G-\u001a:%I\u0015tG-[1o]\u0016\u001c8\u000fI\u0001\nS6\u0004HNU3tKR$\u0012A[\u0001\u000bI\u0016\u001cw\u000eZ3M_>\u0004Hc\u0001;x{B\u0011\u0011&^\u0005\u0003m*\u00121bQ8eKJ\u0014Vm];mi\")\u0001p\u0004a\u0001s\u0006\u0011\u0011N\u001c\t\u0003unl\u0011\u0001L\u0005\u0003y2\u0012!BQ=uK\n+hMZ3s\u0011\u0015qx\u00021\u0001\u0000\u0003\ryW\u000f\u001e\t\u0004u\u0006\u0005\u0011bAA\u0002Y\tQ1\t[1s\u0005V4g-\u001a:\u0003\u000f\u0015s7m\u001c3feN\u0011\u0001c\u0018\u000b\u0003\u0003\u0017\u0001\"A\u001a\t\u0002\u001d9,W\r\u001a+p/JLG/\u001a\"P\u001bV\t1+\u0001\noK\u0016$Gk\\,sSR,'iT'`I\u0015\fHc\u00016\u0002\u0016!9anEA\u0001\u0002\u0004\u0019\u0016a\u00048fK\u0012$vn\u0016:ji\u0016\u0014u*\u0014\u0011\u0002\u0015\u0015t7m\u001c3f\u0019>|\u0007\u000fF\u0003u\u0003;\ty\u0002C\u0003y-\u0001\u0007q\u0010C\u0003\u007f-\u0001\u0007\u00110A\u0007V)\u001a{\u0016GN0D_6lwN\u001c\t\u0003\u001bb\u00192\u0001GA\u0014!\r\t\u0015\u0011F\u0005\u0004\u0003W)#AB!osJ+g\r\u0006\u0002\u0002$\u0005Q\u0011)\u001e;p\u000b:$\u0017.\u00198\u0016\u0005\u0005MrBAA\u001b;\u0005\u0001\u0011aC!vi>,e\u000eZ5b]\u0002\n\u0011BQ5h\u000b:$\u0017.\u00198\u0016\u0005\u0005urBAA ;\u0005\t\u0011A\u0003\"jO\u0016sG-[1oA\u0005aA*\u001b;uY\u0016,e\u000eZ5b]V\u0011\u0011qI\b\u0003\u0003\u0013j\u0012AA\u0001\u000e\u0019&$H\u000f\\3F]\u0012L\u0017M\u001c\u0011")
public abstract class UTF_16_Common
extends Charset {
    private final int scala$scalajs$niocharset$UTF_16_Common$$endianness;

    public static int LittleEndian() {
        return UTF_16_Common$.MODULE$.LittleEndian();
    }

    public static int BigEndian() {
        return UTF_16_Common$.MODULE$.BigEndian();
    }

    public static int AutoEndian() {
        return UTF_16_Common$.MODULE$.AutoEndian();
    }

    public int scala$scalajs$niocharset$UTF_16_Common$$endianness() {
        return this.scala$scalajs$niocharset$UTF_16_Common$$endianness;
    }

    @Override
    public boolean contains(Charset that) {
        return true;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    public UTF_16_Common(String name, String[] aliases, int endianness) {
        this.scala$scalajs$niocharset$UTF_16_Common$$endianness = endianness;
        super(name, aliases);
    }

    public class Decoder
    extends CharsetDecoder {
        private int scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness;

        public int scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness() {
            return this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness;
        }

        public void scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(int x$1) {
            this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness = x$1;
        }

        @Override
        public void implReset() {
            super.implReset();
            this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$$outer().scala$scalajs$niocharset$UTF_16_Common$$endianness());
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            return this.loop$1(in, out);
        }

        public /* synthetic */ UTF_16_Common scala$scalajs$niocharset$UTF_16_Common$Decoder$$$outer() {
            return UTF_16_Common.this;
        }

        private static final char bytes2char$1(int hi, int lo, boolean bigEndian$1) {
            return (char)(bigEndian$1 ? hi << 8 | lo : lo << 8 | hi);
        }

        private final CoderResult loop$1(ByteBuffer in$1, CharBuffer out$1) {
            CoderResult coderResult;
            while (true) {
                int b4;
                boolean wasBOM;
                boolean bl;
                if (in$1.remaining() < 2) {
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                int b1 = in$1.get() & 0xFF;
                int b2 = in$1.get() & 0xFF;
                if (this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness() == 0) {
                    if (b1 == 254 && b2 == 255) {
                        this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(1);
                        bl = true;
                    } else if (b1 == 255 && b2 == 254) {
                        this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(2);
                        bl = true;
                    } else {
                        this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(1);
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                if (wasBOM = bl) continue;
                boolean bigEndian = this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness() == 1;
                char c1 = Decoder.bytes2char$1(b1, b2, bigEndian);
                if (Character.isLowSurrogate(c1)) {
                    in$1.position(in$1.position() - 2);
                    coderResult = CoderResult.malformedForLength(2);
                    break;
                }
                if (!Character.isHighSurrogate(c1)) {
                    if (out$1.remaining() == 0) {
                        in$1.position(in$1.position() - 2);
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    out$1.put(c1);
                    continue;
                }
                if (in$1.remaining() < 2) {
                    in$1.position(in$1.position() - 2);
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                int b3 = in$1.get() & 0xFF;
                char c2 = Decoder.bytes2char$1(b3, b4 = in$1.get() & 0xFF, bigEndian);
                if (!Character.isLowSurrogate(c2)) {
                    in$1.position(in$1.position() - 4);
                    coderResult = CoderResult.malformedForLength(4);
                    break;
                }
                if (out$1.remaining() < 2) {
                    in$1.position(in$1.position() - 4);
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                out$1.put(c1);
                out$1.put(c2);
            }
            return coderResult;
        }

        public Decoder() {
            if (UTF_16_Common.this == null) {
                throw null;
            }
            super(UTF_16_Common.this, 0.5f, 1.0f);
            this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness = UTF_16_Common.this.scala$scalajs$niocharset$UTF_16_Common$$endianness();
        }
    }

    public class Encoder
    extends CharsetEncoder {
        private boolean needToWriteBOM;

        private boolean needToWriteBOM() {
            return this.needToWriteBOM;
        }

        private void needToWriteBOM_$eq(boolean x$1) {
            this.needToWriteBOM = x$1;
        }

        @Override
        public void implReset() {
            super.implReset();
            this.needToWriteBOM_$eq(this.scala$scalajs$niocharset$UTF_16_Common$Encoder$$$outer().scala$scalajs$niocharset$UTF_16_Common$$endianness() == 0);
        }

        @Override
        public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            if (this.needToWriteBOM()) {
                if (out.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)254);
                out.put((byte)255);
                this.needToWriteBOM_$eq(false);
            }
            boolean bigEndian = this.scala$scalajs$niocharset$UTF_16_Common$Encoder$$$outer().scala$scalajs$niocharset$UTF_16_Common$$endianness() != 2;
            return this.loop$2(in, out, bigEndian);
        }

        public /* synthetic */ UTF_16_Common scala$scalajs$niocharset$UTF_16_Common$Encoder$$$outer() {
            return UTF_16_Common.this;
        }

        private static final void putChar$1(char c, boolean bigEndian$2, ByteBuffer out$2) {
            if (bigEndian$2) {
                out$2.put((byte)(c >> 8));
                out$2.put((byte)c);
            } else {
                out$2.put((byte)c);
                out$2.put((byte)(c >> 8));
            }
        }

        private final CoderResult loop$2(CharBuffer in$2, ByteBuffer out$2, boolean bigEndian$2) {
            CoderResult coderResult;
            while (true) {
                if (in$2.remaining() == 0) {
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                char c1 = in$2.get();
                if (Character.isLowSurrogate(c1)) {
                    in$2.position(in$2.position() - 1);
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                if (!Character.isHighSurrogate(c1)) {
                    if (out$2.remaining() < 2) {
                        in$2.position(in$2.position() - 1);
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    Encoder.putChar$1(c1, bigEndian$2, out$2);
                    continue;
                }
                if (in$2.remaining() < 1) {
                    in$2.position(in$2.position() - 1);
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                char c2 = in$2.get();
                if (!Character.isLowSurrogate(c2)) {
                    in$2.position(in$2.position() - 2);
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                if (out$2.remaining() < 4) {
                    in$2.position(in$2.position() - 2);
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                Encoder.putChar$1(c1, bigEndian$2, out$2);
                Encoder.putChar$1(c2, bigEndian$2, out$2);
            }
            return coderResult;
        }

        public Encoder() {
            if (UTF_16_Common.this == null) {
                throw null;
            }
            super(UTF_16_Common.this, 2.0f, 2.0f, UTF_16_Common.this.scala$scalajs$niocharset$UTF_16_Common$$endianness() == 2 ? (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-3, -1}), ClassTag$.MODULE$.Byte()) : (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-1, -3}), ClassTag$.MODULE$.Byte()));
            this.needToWriteBOM = UTF_16_Common.this.scala$scalajs$niocharset$UTF_16_Common$$endianness() == 0;
        }
    }
}

