/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class EscHelpers$ {
    public static final EscHelpers$ MODULE$ = new EscHelpers$();
    private static final int esc = 1;
    private static final int csi = 2;

    public final char ESC() {
        return '\u001b';
    }

    public boolean isEscapeTerminator(char c) {
        return c >= '@' && c <= '~';
    }

    private boolean isCSI(char c) {
        return c == '[';
    }

    private boolean isAnsiTwoCharacterTerminator(char c) {
        return c >= '@' && c <= '_';
    }

    public boolean hasEscapeSequence(String s) {
        return s.indexOf(27) >= 0;
    }

    public String removeEscapeSequences(String s) {
        if (s.isEmpty() || !this.hasEscapeSequence(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        this.nextESC(s, 0, sb);
        return sb.toString();
    }

    private void nextESC(String s, int start, StringBuilder sb) {
        while (true) {
            int next;
            int escIndex;
            if ((escIndex = s.indexOf(27, start)) < 0) break;
            sb.append(s, start, escIndex);
            start = next = escIndex + 1 >= s.length() ? this.skipESC(s, escIndex + 1) : (this.isCSI(s.charAt(escIndex + 1)) ? this.skipESC(s, escIndex + 2) : (this.isAnsiTwoCharacterTerminator(s.charAt(escIndex + 1)) ? escIndex + 2 : this.skipESC(s, escIndex + 1)));
        }
        sb.append(s, start, s.length());
    }

    public int cursorPosition(String s) {
        byte[] bytes = s.getBytes();
        int index = 0;
        int state = 0;
        ArrayBuffer digit = new ArrayBuffer();
        int leftDigit = -1;
        for (int i = 0; i < bytes.length; ++i) {
            byte by = bytes[i];
            if (27 == by) {
                state = esc;
                continue;
            }
            if ((state == esc || state == csi) && by >= 48 && by < 58) {
                state = csi;
                digit.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
                continue;
            }
            if (91 == by && state == esc) {
                state = csi;
                continue;
            }
            if (8 == by) {
                state = 0;
                --index;
                continue;
            }
            if (state == csi) {
                leftDigit = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(new String((byte[])digit.toArray((ClassTag)ClassTag$.MODULE$.Byte()))))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                state = 0;
                char c = (char)by;
                switch (c) {
                    case 'D': {
                        index = package$.MODULE$.max(index - leftDigit, 0);
                        break;
                    }
                    case 'C': {
                        index += leftDigit;
                        break;
                    }
                    case 'K': {
                        break;
                    }
                    case 'J': {
                        if (leftDigit != 2) break;
                        index = 0;
                        break;
                    }
                    case 'm': {
                        break;
                    }
                    case ';': {
                        state = csi;
                        break;
                    }
                }
                digit.clear();
                continue;
            }
            ++index;
        }
        return index;
    }

    public Tuple2<byte[], Object> strip(byte[] bytes, boolean stripAnsi, boolean stripColor) {
        byte[] res = (byte[])Array$.MODULE$.fill(bytes.length, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte());
        boolean i = false;
        IntRef index = IntRef.create((int)0);
        IntRef state = IntRef.create((int)0);
        IntRef limit = IntRef.create((int)0);
        ArrayBuffer digit = new ArrayBuffer();
        IntRef leftDigit = IntRef.create((int)-1);
        IntRef escIndex = IntRef.create((int)-1);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)b -> EscHelpers$.$anonfun$strip$2(index, res, limit, state, escIndex, digit, leftDigit, stripAnsi, stripColor, BoxesRunTime.unboxToByte((Object)b)));
        return new Tuple2((Object)res, (Object)BoxesRunTime.boxToInteger((int)index.elem));
    }

    public String stripMoves(String s) {
        Tuple2<byte[], Object> tuple2 = this.strip(s.getBytes(), true, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] bytes = (byte[])tuple2._1();
        int len = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)len));
        byte[] bytes2 = (byte[])tuple22._1();
        int len2 = tuple22._2$mcI$sp();
        return new String(bytes2, 0, len2);
    }

    public String stripColorsAndMoves(String s) {
        byte[] bytes = s.getBytes();
        byte[] res = (byte[])Array$.MODULE$.fill(bytes.length, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte());
        boolean i = false;
        IntRef index = IntRef.create((int)0);
        IntRef state = IntRef.create((int)0);
        IntRef limit = IntRef.create((int)0);
        ArrayBuffer digit = new ArrayBuffer();
        IntRef leftDigit = IntRef.create((int)-1);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)x0$1 -> EscHelpers$.$anonfun$stripColorsAndMoves$2(state, digit, index, leftDigit, limit, res, BoxesRunTime.unboxToByte((Object)x0$1)));
        new Tuple2((Object)res, (Object)BoxesRunTime.boxToInteger((int)limit.elem));
        return new String(res, 0, limit.elem);
    }

    private int skipESC(String s, int i) {
        while (i < s.length()) {
            if (this.isEscapeTerminator(s.charAt(i))) {
                return i + 1;
            }
            ++i;
        }
        return i;
    }

    public static final /* synthetic */ Object $anonfun$strip$2(IntRef index$1, byte[] res$1, IntRef limit$1, IntRef state$1, IntRef escIndex$1, ArrayBuffer digit$2, IntRef leftDigit$1, boolean stripAnsi$1, boolean stripColor$1, byte b) {
        byte by;
        if (index$1.elem < res$1.length) {
            res$1[index$1.elem] = b;
        }
        ++index$1.elem;
        limit$1.elem = package$.MODULE$.max(limit$1.elem, index$1.elem);
        if (state$1.elem == 0) {
            escIndex$1.elem = -1;
        }
        if (27 == (by = b)) {
            escIndex$1.elem = index$1.elem - 1;
            state$1.elem = esc;
            return BoxedUnit.UNIT;
        }
        if ((state$1.elem == esc || state$1.elem == csi) && by >= 48 && by < 58) {
            state$1.elem = csi;
            return digit$2.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
        }
        if (91 == by && state$1.elem == esc) {
            state$1.elem = csi;
            return BoxedUnit.UNIT;
        }
        if (8 == by) {
            state$1.elem = 0;
            index$1.elem = package$.MODULE$.max(index$1.elem - 1, 0);
            return BoxedUnit.UNIT;
        }
        if (state$1.elem == csi) {
            leftDigit$1.elem = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(new String((byte[])digit$2.toArray((ClassTag)ClassTag$.MODULE$.Byte()))))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            state$1.elem = 0;
            char c = (char)by;
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'J': 
                case 'K': 
                case 'h': {
                    if (!stripAnsi$1) break;
                    index$1.elem = package$.MODULE$.max(escIndex$1.elem, 0);
                    break;
                }
                case 'm': {
                    if (!stripColor$1) break;
                    index$1.elem = escIndex$1.elem;
                    break;
                }
                case ';': 
                case '?': 
                case 's': 
                case 'u': {
                    state$1.elem = csi;
                    break;
                }
            }
            digit$2.clear();
            return BoxedUnit.UNIT;
        }
        if (state$1.elem == esc) {
            state$1.elem = 0;
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$stripColorsAndMoves$2(IntRef state$2, ArrayBuffer digit$3, IntRef index$2, IntRef leftDigit$2, IntRef limit$2, byte[] res$2, byte x0$1) {
        byte by = x0$1;
        if (27 == by) {
            state$2.elem = esc;
            return BoxedUnit.UNIT;
        }
        if ((state$2.elem == esc || state$2.elem == csi) && by >= 48 && by < 58) {
            state$2.elem = csi;
            return digit$3.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
        }
        if (91 == by && state$2.elem == esc) {
            state$2.elem = csi;
            return BoxedUnit.UNIT;
        }
        if (8 == by) {
            state$2.elem = 0;
            index$2.elem = package$.MODULE$.max(index$2.elem - 1, 0);
            return BoxedUnit.UNIT;
        }
        if (state$2.elem == csi) {
            leftDigit$2.elem = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(new String((byte[])digit$3.toArray((ClassTag)ClassTag$.MODULE$.Byte()))))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            state$2.elem = 0;
            char c = (char)by;
            switch (c) {
                case 'h': {
                    index$2.elem = package$.MODULE$.max(index$2.elem - 1, 0);
                    break;
                }
                case 'D': {
                    index$2.elem = package$.MODULE$.max(index$2.elem - leftDigit$2.elem, 0);
                    break;
                }
                case 'C': {
                    index$2.elem = package$.MODULE$.min(limit$2.elem, package$.MODULE$.min(index$2.elem + leftDigit$2.elem, res$2.length - 1));
                    break;
                }
                case 'J': 
                case 'K': {
                    if (leftDigit$2.elem > 0) {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), index$2.elem).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                            res$2[x$2] = 32;
                        });
                        break;
                    }
                    res$2[index$2.elem] = 32;
                    break;
                }
                case 'm': {
                    break;
                }
                case ';': {
                    state$2.elem = csi;
                    break;
                }
                default: {
                    state$2.elem = csi;
                    break;
                }
            }
            digit$3.clear();
            return BoxedUnit.UNIT;
        }
        if (state$2.elem == esc) {
            state$2.elem = 0;
            return BoxedUnit.UNIT;
        }
        res$2[index$2.elem] = by;
        ++index$2.elem;
        limit$2.elem = package$.MODULE$.max(limit$2.elem, index$2.elem);
        return BoxedUnit.UNIT;
    }

    private EscHelpers$() {
    }
}

