/*
 * Decompiled with CFR 0.152.
 */
package scoverage;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scoverage.ClassType$;
import scoverage.Constants$;
import scoverage.Coverage;
import scoverage.Location;
import scoverage.Statement;
import scoverage.Statement$;

public final class Serializer$ {
    public static final Serializer$ MODULE$ = new Serializer$();

    public void serialize(Coverage coverage, String dataDir) {
        this.serialize(coverage, this.coverageFile(dataDir));
    }

    public void serialize(Coverage coverage, File file) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Codec$.MODULE$.UTF8().name()));
        try {
            this.serialize(coverage, writer);
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }

    public void serialize(Coverage coverage, Writer writer) {
        Serializer$.writeHeader$1(writer);
        ((IterableOnceOps)coverage.statements().toSeq().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable)stmt -> {
            Serializer$.writeStatement$1(stmt, writer);
            return BoxedUnit.UNIT;
        });
    }

    public File coverageFile(File dataDir) {
        return this.coverageFile(dataDir.getAbsolutePath());
    }

    public File coverageFile(String dataDir) {
        return new File(dataDir, Constants$.MODULE$.CoverageFileName());
    }

    public Coverage deserialize(File file) {
        Coverage coverage;
        try (BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8());){
            coverage = this.deserialize((Iterator<String>)source.getLines());
        }
        return coverage;
    }

    public Coverage deserialize(Iterator<String> lines) {
        String headerFirstLine;
        String string = headerFirstLine = (String)lines.next();
        String string2 = "# Coverage data, format version: 2.0";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Wrong file format");
        Iterator linesWithoutHeader = lines.dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("#")));
        Coverage coverage = new Coverage();
        while (!linesWithoutHeader.isEmpty()) {
            Iterator oneStatementLines = linesWithoutHeader.takeWhile((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Serializer$.$anonfun$deserialize$3(x$3)));
            Statement statement = Serializer$.toStatement$1(oneStatementLines);
            if (statement.ignored()) {
                coverage.addIgnoredStatement(statement);
                continue;
            }
            coverage.add(statement);
        }
        return coverage;
    }

    private static final void writeHeader$1(Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("# Coverage data, format version: 2.0\n                      |# Statement data:\n                      |# - id\n                      |# - source path\n                      |# - package name\n                      |# - class name\n                      |# - class type (Class, Object or Trait)\n                      |# - full class name\n                      |# - method name\n                      |# - start offset\n                      |# - end offset\n                      |# - line number\n                      |# - symbol name\n                      |# - tree name\n                      |# - is branch\n                      |# - invocations count\n                      |# - is ignored\n                      |# - description (can be multi-line)\n                      |# '\f' sign\n                      |# ------------------------------------------\n                      |")).replaceAll("(\r\n)|\n|\r", "\n"));
    }

    private static final void writeStatement$1(Statement stmt, Writer writer) {
        writer.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(409).append(stmt.id()).append("\n                      |").append(stmt.location().sourcePath()).append("\n                      |").append(stmt.location().packageName()).append("\n                      |").append(stmt.location().className()).append("\n                      |").append(stmt.location().classType()).append("\n                      |").append(stmt.location().fullClassName()).append("\n                      |").append(stmt.location().method()).append("\n                      |").append(stmt.start()).append("\n                      |").append(stmt.end()).append("\n                      |").append(stmt.line()).append("\n                      |").append(stmt.symbolName()).append("\n                      |").append(stmt.treeName()).append("\n                      |").append(stmt.branch()).append("\n                      |").append(stmt.count()).append("\n                      |").append(stmt.ignored()).append("\n                      |").append(stmt.desc()).append("\n                      |\f\n                      |").toString())).replaceAll("(\r\n)|\n|\r", "\n"));
    }

    private static final Statement toStatement$1(Iterator lines) {
        int id = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        String sourcePath = (String)lines.next();
        String packageName = (String)lines.next();
        String className = (String)lines.next();
        String classType = (String)lines.next();
        String fullClassName = (String)lines.next();
        String method = (String)lines.next();
        Location loc = new Location(packageName, className, fullClassName, ClassType$.MODULE$.fromString(classType), method, sourcePath);
        int start = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        int end = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        int lineNo = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        String symbolName = (String)lines.next();
        String treeName = (String)lines.next();
        boolean branch = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        int count = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        boolean ignored = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)lines.next()));
        String desc = lines.toList().mkString("\n");
        return new Statement(loc, id, start, end, lineNo, desc, symbolName, treeName, branch, count, ignored, Statement$.MODULE$.apply$default$12());
    }

    public static final /* synthetic */ boolean $anonfun$deserialize$3(String x$3) {
        String string = x$3;
        String string2 = "\f";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private Serializer$() {
    }
}

