/*
 * Decompiled with CFR 0.152.
 */
package scoverage.report;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scoverage.Coverage;
import scoverage.IOUtils$;
import scoverage.MeasuredClass;
import scoverage.MeasuredFile;
import scoverage.MeasuredPackage;
import scoverage.report.BaseReportWriter;
import scoverage.report.CodeGrid;
import scoverage.report.StatementWriter;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\f\u0018\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003G\u0001\u0011\u0005q\tC\u0003G\u0001\u0011\u0005A\nC\u0003G\u0001\u0011\u0005q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003_\u0001\u0011%q\fC\u0003f\u0001\u0011%a\rC\u0003m\u0001\u0011%Q\u000eC\u0003u\u0001\u0011%Q\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^\t\u00192kY8wKJ\fw-\u001a%u[2<&/\u001b;fe*\u0011\u0001$G\u0001\u0007e\u0016\u0004xN\u001d;\u000b\u0003i\t\u0011b]2pm\u0016\u0014\u0018mZ3\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011aF\u0005\u0003A]\u0011\u0001CQ1tKJ+\u0007o\u001c:u/JLG/\u001a:\u0002#M|WO]2f\t&\u0014Xm\u0019;pe&,7\u000fE\u0002$[Ar!\u0001\n\u0016\u000f\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dZ\u0012A\u0002\u001fs_>$h(C\u0001*\u0003\u0015\u00198-\u00197b\u0013\tYC&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003%J!AL\u0018\u0003\u0007M+\u0017O\u0003\u0002,YA\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0003S>T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028e\t!a)\u001b7f\u0003%yW\u000f\u001e9vi\u0012K'/\u0001\bt_V\u00148-Z#oG>$\u0017N\\4\u0011\u0007mbd(D\u0001-\u0013\tiDF\u0001\u0004PaRLwN\u001c\t\u0003\u007f\rs!\u0001Q!\u0011\u0005\u0015b\u0013B\u0001\"-\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tc\u0013A\u0002\u001fj]&$h\b\u0006\u0003I\u0013*[\u0005C\u0001\u0010\u0001\u0011\u0015\tC\u00011\u0001#\u0011\u0015AD\u00011\u00011\u0011\u0015ID\u00011\u0001;)\rAUJ\u0014\u0005\u0006C\u0015\u0001\rA\t\u0005\u0006q\u0015\u0001\r\u0001\r\u000b\u0004\u0011B\u0013\u0006\"B)\u0007\u0001\u0004\u0001\u0014aD:pkJ\u001cW\rR5sK\u000e$xN]=\t\u000ba2\u0001\u0019\u0001\u0019\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005UC\u0006CA\u001eW\u0013\t9FF\u0001\u0003V]&$\b\"B-\b\u0001\u0004Q\u0016\u0001C2pm\u0016\u0014\u0018mZ3\u0011\u0005mcV\"A\r\n\u0005uK\"\u0001C\"pm\u0016\u0014\u0018mZ3\u0002\u0019]\u0014\u0018\u000e^3QC\u000e\\\u0017mZ3\u0015\u0005U\u0003\u0007\"B1\t\u0001\u0004\u0011\u0017a\u00019lOB\u00111lY\u0005\u0003If\u0011q\"T3bgV\u0014X\r\u001a)bG.\fw-Z\u0001\noJLG/\u001a$jY\u0016$\"!V4\t\u000b!L\u0001\u0019A5\u0002\u000b54\u0017\u000e\\3\u0011\u0005mS\u0017BA6\u001a\u00051iU-Y:ve\u0016$g)\u001b7f\u0003m\u0001\u0018mY6bO\u0016|e/\u001a:wS\u0016<(+\u001a7bi&4X\rU1uQR\u0011an\u001d\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cR\nA\u0001\\1oO&\u0011A\t\u001d\u0005\u0006C*\u0001\rAY\u0001\tM&dW\rU1hKR\u0011a\u000f \t\u0003ojl\u0011\u0001\u001f\u0006\u0003s2\n1\u0001_7m\u0013\tY\bP\u0001\u0003O_\u0012,\u0007\"\u00025\f\u0001\u0004I\u0017A\u00025fC\u0012,'/F\u0001\u0000!\r9\u0018\u0011A\u0005\u0004\u0003\u0007A(\u0001B#mK6\fq\u0002]1dW\u0006<Wm\u0014<feZLWm\u001e\u000b\u0004m\u0006%\u0001BBA\u0006\u001b\u0001\u0007!-\u0001\u0003qC\u000e\\\u0017\u0001D2mCN\u001cXm\u001d+bE2,G#\u0002<\u0002\u0012\u0005\u0005\u0002bBA\n\u001d\u0001\u0007\u0011QC\u0001\bG2\f7o]3t!\u0015\u0019\u0013qCA\u000e\u0013\r\tIb\f\u0002\t\u0013R,'/\u00192mKB\u00191,!\b\n\u0007\u0005}\u0011DA\u0007NK\u0006\u001cXO]3e\u00072\f7o\u001d\u0005\b\u0003Gq\u0001\u0019AA\u0013\u0003\u001d\tG\r\u001a)bi\"\u00042aOA\u0014\u0013\r\tI\u0003\f\u0002\b\u0005>|G.Z1o\u0003!\u0019G.Y:t%><Hc\u0001<\u00020!9\u0011\u0011G\bA\u0002\u0005m\u0011!B6mCN\u001c\u0018a\u00039bG.\fw-\u001a'jgR$2A^A\u001c\u0011\u0015I\u0006\u00031\u0001[\u0003\u0015\u0011\u0018n]6t)\u0015y\u0018QHA \u0011\u0015I\u0016\u00031\u0001[\u0011\u001d\t\t%\u0005a\u0001\u0003\u0007\nQ\u0001\\5nSR\u00042aOA#\u0013\r\t9\u0005\f\u0002\u0004\u0013:$\u0018!\u00039bG.\fw-Z:3)\ry\u0018Q\n\u0005\u00063J\u0001\rAW\u0001\t_Z,'O^5foR\u0019a/a\u0015\t\u000be\u001b\u0002\u0019\u0001.\u0002\u000bM$\u0018\r^:\u0015\u0007Y\fI\u0006C\u0003Z)\u0001\u0007!,A\u0004qYV<\u0017N\\:\u0016\u0005\u0005}\u0003cA<\u0002b%\u0019\u00111\r=\u0003\u00159{G-\u001a\"vM\u001a,'\u000f")
public class ScoverageHtmlWriter
extends BaseReportWriter {
    private final File outputDir;
    private final Option<String> sourceEncoding;

    public void write(Coverage coverage) {
        File indexFile = new File(new StringBuilder(11).append(this.outputDir.getAbsolutePath()).append("/index.html").toString());
        File packageFile = new File(new StringBuilder(14).append(this.outputDir.getAbsolutePath()).append("/packages.html").toString());
        File overviewFile = new File(new StringBuilder(14).append(this.outputDir.getAbsolutePath()).append("/overview.html").toString());
        String index = IOUtils$.MODULE$.readStreamAsString(this.getClass().getResourceAsStream("/scoverage/index.html"));
        IOUtils$.MODULE$.writeToFile(indexFile, index);
        IOUtils$.MODULE$.writeToFile(packageFile, this.packageList(coverage).toString());
        IOUtils$.MODULE$.writeToFile(overviewFile, this.overview(coverage).toString());
        coverage.packages().foreach((Function1 & Serializable)pkg -> {
            this.writePackage(pkg);
            return BoxedUnit.UNIT;
        });
    }

    private void writePackage(MeasuredPackage pkg) {
        File file = new File(this.outputDir, this.packageOverviewRelativePath(pkg));
        file.getParentFile().mkdirs();
        IOUtils$.MODULE$.writeToFile(file, this.packageOverview(pkg).toString());
        pkg.files().foreach((Function1 & Serializable)mfile -> {
            this.writeFile(mfile);
            return BoxedUnit.UNIT;
        });
    }

    private void writeFile(MeasuredFile mfile) {
        File file = new File(this.outputDir, new StringBuilder(5).append(this.relativeSource(mfile.source())).append(".html").toString());
        file.getParentFile().mkdirs();
        IOUtils$.MODULE$.writeToFile(file, this.filePage(mfile).toString());
    }

    private String packageOverviewRelativePath(MeasuredPackage pkg) {
        return new StringBuilder(5).append(pkg.name().replace("<empty>", "(empty)")).append(".html").toString();
    }

    private Node filePage(MeasuredFile mfile) {
        String filename = new StringBuilder(5).append(this.relativeSource(mfile.source())).append(".html").toString();
        String css = "table.codegrid { font-family: monospace; font-size: 12px; width: auto!important; }table.statementlist { width: auto!important; font-size: 13px; } table.codegrid td { padding: 0!important; border: 0!important } table td.linenumber { width: 40px!important; } ";
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)filename);
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)this.plugins());
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)css);
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "style", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("nav nav-tabs"), (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tab"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("#codegrid"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Codegrid"));
        $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tab"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("href", (Seq)new Text("#statementlist"), (MetaData)$md6);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Statement List"));
        $buf9.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("tab-content"), (MetaData)$md7);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("id", (Seq)new Text("codegrid"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("tab-pane active"), (MetaData)$md8);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        $buf12.$amp$plus((Object)Unparsed$.MODULE$.apply(new CodeGrid(mfile, this.sourceEncoding).highlighted()));
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n          "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("id", (Seq)new Text("statementlist"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("tab-pane"), (MetaData)$md9);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            "));
        $buf13.$amp$plus((Object)new StatementWriter(mfile).output());
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Elem header() {
        void var2_2;
        String css = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(".meter {\n                |        height: 14px;\n                |        position: relative;\n                |        background: #BB2020;\n                |}\n                |\n                |.meter span {\n                |\tdisplay: block;\n                |\theight: 100%;\n                |\tbackground-color: rgb(43,194,83);\n                |\tbackground-image: -webkit-gradient(\n                |\t  linear,\n                |\t  left bottom,\n                |\t  left top,\n                |\t  color-stop(0, rgb(43,194,83)),\n                |\t  color-stop(1, rgb(84,240,84))\n                |\t );\n                |\tbackground-image: -webkit-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -moz-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -ms-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\tbackground-image: -o-linear-gradient(\n                |\t  center bottom,\n                |\t  rgb(43,194,83) 37%,\n                |\t  rgb(84,240,84) 69%\n                |\t );\n                |\t-webkit-box-shadow:\n                |\t  inset 0 2px 9px  rgba(255,255,255,0.3),\n                |\t  inset 0 -2px 6px rgba(0,0,0,0.4);\n                |\t-moz-box-shadow:\n                |\t  inset 0 2px 9px  rgba(255,255,255,0.3),\n                |\t  inset 0 -2px 6px rgba(0,0,0,0.4);\n                |\tposition: relative;\n                |\toverflow: hidden;\n                |}"));
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Scoverage Code Coverage"));
        $buf.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.plugins());
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)css);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "style", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Node packageOverview(MeasuredPackage pack) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.header());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)this.classesTable((Iterable<MeasuredClass>)pack.classes(), false));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public Node classesTable(Iterable<MeasuredClass> classes, boolean addPath) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-size:13px"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            Class\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            Source file\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            Lines\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            Methods\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            Statements\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            Invoked\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            Coverage\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            Branches\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n            Invoked\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n            Coverage\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus(((IterableOps)classes.toSeq().sortBy((Function1 & Serializable)x$1 -> x$1.fullClassName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)klass -> this.classRow((MeasuredClass)klass)));
        $buf16.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public Node classRow(MeasuredClass klass) {
        File fileRelativeToSource = new File(new StringBuilder(5).append(this.relativeSource(klass.source())).append(".html").toString());
        String path = fileRelativeToSource.getParent();
        String value = fileRelativeToSource.getName();
        String filename = path != "" ? fileRelativeToSource.toString().replace(File.separator, "/") : value;
        String statement0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(klass.statementCoveragePercent())))).toString();
        String branch0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(klass.branchCoveragePercent())))).toString();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("href", filename, (MetaData)$md);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)klass.displayClassName());
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus(klass.statements().headOption().map((Function1 & Serializable)x$2 -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$2.source()), File.separatorChar)))).getOrElse((Function0 & Serializable)() -> ""));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.loc())).toString());
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.methodCount())).toString());
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.statementCount())).toString());
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.invokedStatementCount())).toString());
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md2);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(statement0f).append("%").toString(), (MetaData)$md3);
        $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)klass.statementCoverageFormatted());
        $buf11.$amp$plus((Object)new Text("\n        %\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf12.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.branchCount())).toString());
        $buf12.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf13.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.invokedBranchesCount())).toString());
        $buf13.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md4);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(branch0f).append("%").toString(), (MetaData)$md5);
        $buf15.$amp$plus((Object)new Elem(null, "span", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf15.$amp$plus((Object)new Text("\n        "));
        $buf14.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf14.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        $buf16.$amp$plus((Object)klass.branchCoverageFormatted());
        $buf16.$amp$plus((Object)new Text("\n        %\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Node packageList(Coverage coverage) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          Scoverage Code Coverage\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)this.plugins());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("font-size: 13px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n                "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("target", (Seq)new Text("mainFrame"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("overview.html"), (MetaData)$md5);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("All packages"));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n              "));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)coverage.statementCoverageFormatted());
        $buf10.$amp$plus((Object)new Text("%"));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n            "));
        $buf11.$amp$plus(coverage.packages().map((Function1 & Serializable)arg -> {
            void var2_2;
            void var3_3;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n                "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("target", (Seq)new Text("mainFrame"), (MetaData)$md);
            $md = new UnprefixedAttribute("href", this.packageOverviewRelativePath((MeasuredPackage)arg), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)arg.name());
            $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n              "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n              "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)arg.statementCoverageFormatted());
            $buf4.$amp$plus((Object)new Text("%"));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n            "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
        }));
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "table", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public Elem risks(Coverage coverage, int limit) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-size: 12px"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("tablesorter table table-striped"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            Class\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            Lines\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n            Methods\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            Statements\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n            Statement Rate\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            Branches\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n            Branch Rate\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus(coverage.risks(limit).map((Function1 & Serializable)klass -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n            "));
            $buf2.$amp$plus((Object)klass.displayClassName());
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.loc())).toString());
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.methodCount())).toString());
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n            "));
            $buf5.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.statementCount())).toString());
            $buf5.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n            "));
            $buf6.$amp$plus((Object)klass.statementCoverageFormatted());
            $buf6.$amp$plus((Object)new Text("\n            %\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)klass.branchCount())).toString());
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf8 = new NodeBuffer();
            $buf8.$amp$plus((Object)new Text("\n            "));
            $buf8.$amp$plus((Object)klass.branchCoverageFormatted());
            $buf8.$amp$plus((Object)new Text("\n            %\n          "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf.$amp$plus((Object)new Text("\n        "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        }));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public Elem packages2(Coverage coverage) {
        void var3_3;
        scala.collection.immutable.Seq rows = (scala.collection.immutable.Seq)coverage.packages().map((Function1 & Serializable)arg -> {
            void var1_1;
            void var3_3;
            void var2_2;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)arg.name());
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2)));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)arg.invokedClasses())).toString());
            $buf3.$amp$plus((Object)new Text("\n          /\n          "));
            $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)arg.classCount()));
            $buf3.$amp$plus((Object)new Text("\n          (\n          "));
            $buf3.$amp$plus((Object)((Object)BoxesRunTime.boxToDouble((double)arg.classCoverage())).toString());
            $buf3.$amp$plus((Object)new Text("\n          %)\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)));
            $buf.$amp$plus((Object)new Text("\n        "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n          "));
            $buf4.$amp$plus((Object)arg.invokedStatements().toString());
            $buf4.$amp$plus((Object)new Text("\n          /\n          "));
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)arg.statementCount()));
            $buf4.$amp$plus((Object)new Text("\n          (\n          "));
            $buf4.$amp$plus((Object)arg.statementCoverageFormatted());
            $buf4.$amp$plus((Object)new Text("\n          %)\n        "));
            $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
        });
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)rows);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Node overview(Coverage coverage) {
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.header());
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", (Seq)new Text("font-family: monospace;"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("alert alert-info"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          SCoverage\n        "));
        $buf3.$amp$plus((Object)new Elem(null, "b", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n        generated at\n        "));
        $buf3.$amp$plus((Object)new Date().toString());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("overview"), (MetaData)$md3);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("stats"), (MetaData)$md4);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)this.stats(coverage));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)this.classesTable((Iterable<MeasuredClass>)coverage.classes(), true));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var2_2));
    }

    public Node stats(Coverage coverage) {
        String statement0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(coverage.statementCoveragePercent())))).toString();
        String branch0f = ((Object)BoxesRunTime.boxToInteger((int)((int)Math.round(coverage.branchCoveragePercent())))).toString();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          Lines of code:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.loc())).toString());
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          Files:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.fileCount())).toString());
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          Classes:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.classCount())).toString());
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n          Methods:\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n          "));
        $buf10.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.methodCount())).toString());
        $buf10.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n          Lines per file:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("\n          "));
        $buf13.$amp$plus((Object)coverage.linesPerFileFormatted());
        $buf13.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("\n          Packages:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf15.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.packageCount())).toString());
        $buf15.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n          Classes per package:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n          "));
        $buf17.$amp$plus((Object)coverage.avgClassesPerPackageFormatted());
        $buf17.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("\n          Methods per class:\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf11.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n          "));
        $buf19.$amp$plus((Object)coverage.avgMethodsPerClassFormatted());
        $buf19.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n          Total statements:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n          "));
        $buf22.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.statementCount())).toString());
        $buf22.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("\n          Invoked statements:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf24 = new NodeBuffer();
        $buf24.$amp$plus((Object)new Text("\n          "));
        $buf24.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.invokedStatementCount())).toString());
        $buf24.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf25 = new NodeBuffer();
        $buf25.$amp$plus((Object)new Text("\n          Total branches:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf26 = new NodeBuffer();
        $buf26.$amp$plus((Object)new Text("\n          "));
        $buf26.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.branchCount())).toString());
        $buf26.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf27 = new NodeBuffer();
        $buf27.$amp$plus((Object)new Text("\n          Invoked branches:\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf28 = new NodeBuffer();
        $buf28.$amp$plus((Object)new Text("\n          "));
        $buf28.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.invokedBranchesCount())).toString());
        $buf28.$amp$plus((Object)new Text("\n        "));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28)));
        $buf20.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf29 = new NodeBuffer();
        $buf29.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf30 = new NodeBuffer();
        $buf30.$amp$plus((Object)new Text("\n          Ignored statements:\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf30)));
        $buf29.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf31 = new NodeBuffer();
        $buf31.$amp$plus((Object)new Text("\n          "));
        $buf31.$amp$plus((Object)((Object)BoxesRunTime.boxToInteger((int)coverage.ignoredStatementCount())).toString());
        $buf31.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf31)));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n        "));
        $buf29.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf29.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf32 = new NodeBuffer();
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf33 = new NodeBuffer();
        $buf33.$amp$plus((Object)new Text("\n          Statement coverage:\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf33)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf34 = new NodeBuffer();
        $buf34.$amp$plus((Object)new Text("\n          "));
        $buf34.$amp$plus((Object)coverage.statementCoverageFormatted());
        $buf34.$amp$plus((Object)new Text("\n          %\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf34)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md2);
        NodeBuffer $buf35 = new NodeBuffer();
        $buf35.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md3);
        NodeBuffer $buf36 = new NodeBuffer();
        $buf36.$amp$plus((Object)new Text("\n            "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(statement0f).append("%").toString(), (MetaData)$md4);
        $buf36.$amp$plus((Object)new Elem(null, "span", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf36.$amp$plus((Object)new Text("\n          "));
        $buf35.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf36)));
        $buf35.$amp$plus((Object)new Text("\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf35)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf37 = new NodeBuffer();
        $buf37.$amp$plus((Object)new Text("\n          Branch coverage:\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf37)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf38 = new NodeBuffer();
        $buf38.$amp$plus((Object)new Text("\n          "));
        $buf38.$amp$plus((Object)coverage.branchCoverageFormatted());
        $buf38.$amp$plus((Object)new Text("\n          %\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf38)));
        $buf32.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md5);
        NodeBuffer $buf39 = new NodeBuffer();
        $buf39.$amp$plus((Object)new Text("\n          "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("meter"), (MetaData)$md6);
        NodeBuffer $buf40 = new NodeBuffer();
        $buf40.$amp$plus((Object)new Text("\n            "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("style", new StringBuilder(8).append("width: ").append(branch0f).append("%").toString(), (MetaData)$md7);
        $buf40.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf40.$amp$plus((Object)new Text("\n          "));
        $buf39.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf40)));
        $buf39.$amp$plus((Object)new Text("\n        "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf39)));
        $buf32.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf32)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    /*
     * WARNING - void declaration
     */
    public NodeBuffer plugins() {
        void var1_1;
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("src", (Seq)new Text("https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"), (MetaData)$md);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", (Seq)new Text("https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.20.1/css/theme.default.min.css"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("src", (Seq)new Text("https://cdnjs.cloudflare.com/ajax/libs/jquery.tablesorter/2.20.1/js/jquery.tablesorter.min.js"), (MetaData)$md3);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("text/css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", (Seq)new Text("https://netdna.bootstrapcdn.com/bootstrap/3.0.3/css/bootstrap.min.css"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("src", (Seq)new Text("https://netdna.bootstrapcdn.com/bootstrap/3.0.3/js/bootstrap.min.js"), (MetaData)$md5);
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md6);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)Unparsed$.MODULE$.apply("$(document).ready(function() {$(\".tablesorter\").tablesorter();});"));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        return var1_1;
    }

    public ScoverageHtmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir, Option<String> sourceEncoding) {
        this.outputDir = outputDir;
        this.sourceEncoding = sourceEncoding;
        super(sourceDirectories, outputDir);
    }

    public ScoverageHtmlWriter(scala.collection.immutable.Seq<File> sourceDirectories, File outputDir) {
        this(sourceDirectories, outputDir, (Option<String>)None$.MODULE$);
    }

    public ScoverageHtmlWriter(File sourceDirectory, File outputDir) {
        this((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{sourceDirectory}))), outputDir);
    }
}

