/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jdbc.spring;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.sfm.jdbc.JdbcMapper;
import org.sfm.utils.ListCollectorHandler;
import org.sfm.utils.RowHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

public final class JdbcTemplateMapper<T>
implements RowMapper<T>,
PreparedStatementCallback<List<T>>,
ResultSetExtractor<List<T>> {
    private final JdbcMapper<T> mapper;

    public JdbcTemplateMapper(JdbcMapper<T> mapper) {
        this.mapper = mapper;
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        return (T)this.mapper.map(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
        ResultSet rs = ps.executeQuery();
        try {
            Object object = this.extractData(rs);
            return object;
        }
        finally {
            rs.close();
        }
    }

    public List<T> extractData(ResultSet rs) throws SQLException, DataAccessException {
        return ((ListCollectorHandler)this.mapper.forEach(rs, (RowHandler)new ListCollectorHandler())).getList();
    }

    public <H extends RowHandler<T>> PreparedStatementCallback<H> newPreparedStatementCallback(final H handler) {
        return new PreparedStatementCallback<H>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public H doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ResultSet rs = ps.executeQuery();
                ResultSetExtractor<RowHandler> resultSetExtractor = JdbcTemplateMapper.this.newResultSetExtractor(handler);
                try {
                    RowHandler rowHandler = (RowHandler)resultSetExtractor.extractData(rs);
                    return rowHandler;
                }
                finally {
                    rs.close();
                }
            }
        };
    }

    public <H extends RowHandler<T>> ResultSetExtractor<H> newResultSetExtractor(final H handler) {
        return new ResultSetExtractor<H>(){

            public H extractData(ResultSet rs) throws SQLException, DataAccessException {
                return JdbcTemplateMapper.this.mapper.forEach(rs, handler);
            }
        };
    }
}

