/*
 * EmptyInputStream.java October 2002
 *
 * Copyright (C) 2002, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.http.core;

import java.io.InputStream;

/**
 * The <code>EmptyInputStream</code> object provides a stream that 
 * is immediately empty. Each read method with this input stream 
 * will return a -1 value indicating that the stream has come to an
 * end and no more data can be read from it.
 * 
 * @author Niall Gallagher
 */
class EmptyInputStream extends InputStream {
   
   /**
    * This is used to provide a -1 value when an attempt is made to
    * read from the stream. Implementing this method as so also 
    * ensures that all the other read methods return a -1 value.
    * 
    * @return this returns a -1 when an attempt is made to read
    */
   public int read() {
      return -1;
   }

}
