/*
 * NegotiationException.java February 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport;

/**
* The <code>NegotiationException</code> object is thrown when there 
* is a problem with a negotiation. Typically this is done thrown if
* there is a problem reading or writing to in the negotiation.
* 
* @author Niall Gallagher
*/
class NegotiationException extends TransportException {
  
  /**
   * Constructor for the <code>NegotiationException</code> object. If
   * there is a problem sending or reading in a negotiation then it
   * will throw a negotiation exception to report the error.
   * 
   * @param message this is the message associated with the error
   */
  public NegotiationException(String message) {
     super(message);
  }
}
