/*
 * PacketException.java February 2008
 *
 * Copyright (C) 2008, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport;

/**
 * The <code>PacketException</code> represents an exception that 
 * is thrown when there is a problem with a packet operation. This
 * is typically thrown when the packet is closed and an attempt
 * is made to either append or write the packets contents.
 * 
 * @author Niall Gallagher
 */
class PacketException extends TransportException {
   
   /**
    * Constructor for the <code>PacketException</code> object. This
    * creates an exception that takes a template string an a list
    * of arguments to pass in to the message template.
    * 
    * @param message this is the message template string to use
    */
   public PacketException(String message) {
      super(message);
   }
   
   /**
    * Constructor for the <code>PacketException</code> object. This
    * creates an exception that takes a template string an a list
    * of arguments to pass in to the message template.
    * 
    * @param message this is the message template string to use
    * @param cause this is the root cause of the exception
    */
   public PacketException(String message, Throwable cause) {
      super(message, cause);
   }
}
