/*
 * ConnectionException.java February 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport.connect;

import java.io.IOException;

/**
 * The <code>ConnectionException</code> is thrown if there is a problem
 * establishing a connection to the server. Such a problem can occur 
 * if the server has been stopped when a new connection arrives. This
 * can also be thrown if some other connection related issue occurs.
 * 
 * @author Niall Gallagher
 */
class ConnectionException extends IOException {
   
   /**
    * Constructor for the <code>ConnectionException</code> object. This
    * is used to represent an exception that is thrown when an error
    * occurs during the connect process. Typically this is thrown if
    * there is a problem connecting or accepting from a socket.
    * 
    * @param message this is the message describing the exception
    */
   public ConnectionException(String message) {
      super(message);
   }
   
   /**
    * Constructor for the <code>ConnectionException</code> object. This
    * is used to represent an exception that is thrown when an error
    * occurs during the connect process. Typically this is thrown if
    * there is a problem connecting or accepting from a socket.
    * 
    * @param message this is the message describing the exception
    * @param cause this is the cause of the producer exception
    */
   public ConnectionException(String message, Throwable cause) {
      super(message);
      initCause(cause);
   }
}
