/*
 * Operation.java February 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport.reactor;

import java.nio.channels.SelectableChannel;

/**
 * The <code>Operation</code> interface is used to describe a task
 * that can be executed when the associated channel is ready for some
 * operation. Typically the <code>SelectableChannel</code> is used to
 * register with a selector with a set of given interested operations
 * when those operations can be performed this is executed.
 *
 * @author Niall Gallagher
 *
 * @see org.simpleframework.transport.reactor.Reactor
 */ 
public interface Operation extends Runnable {       

  /**
   * This is the <code>SelectableChannel</code> which is used to 
   * determine if the operation should be executed. If the channel   
   * is ready for a given I/O event it can be run. For instance if
   * the operation is used to perform some form of read operation
   * it can be executed when ready to read data from the channel.
   *
   * @return this returns the channel used to govern execution
   */ 
  public SelectableChannel getChannel();        

  /**
   * This is used to cancel the operation if it has timed out. This
   * is typically invoked when it has been waiting in a selector for
   * an extended duration of time without any active operations on
   * it. In such a case the reactor must purge the operation to free
   * the memory and open channels associated with the operation.
   */ 
  public void cancel();
}


