/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.core.Channel;
import org.simpleframework.http.core.Collector;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.CookieTracker;
import org.simpleframework.http.core.Dispatcher;
import org.simpleframework.http.core.EntityCollector;
import org.simpleframework.http.core.Reader;
import org.simpleframework.http.core.Selector;
import org.simpleframework.http.core.Tracker;
import org.simpleframework.transport.reactor.ExecutorReactor;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.thread.PoolExecutor;

class ContainerSelector
implements Selector {
    private final PoolExecutor executor;
    private final PoolExecutor collect;
    private final Allocator allocator;
    private final Container handler;
    private final Reactor reactor;
    private final Tracker tracker;

    public ContainerSelector(Container handler, Allocator allocator, int count, int select) throws IOException {
        this.collect = new PoolExecutor(Reader.class, count);
        this.reactor = new ExecutorReactor(this.collect, select);
        this.executor = new PoolExecutor(Dispatcher.class, count);
        this.tracker = new CookieTracker();
        this.allocator = allocator;
        this.handler = handler;
    }

    public void start(Channel channel) throws IOException {
        this.start(new EntityCollector(this.allocator, this.tracker, channel));
    }

    public void start(Collector collector) throws IOException {
        this.reactor.process(new Reader(this, collector));
    }

    public void select(Collector collector) throws IOException {
        this.reactor.process(new Reader(this, collector), 1);
    }

    public void ready(Collector collector) throws IOException {
        this.executor.execute(new Dispatcher(this.handler, this, collector));
    }

    public void stop() throws IOException {
        try {
            this.tracker.close();
            this.reactor.stop();
            this.executor.stop();
            this.collect.stop();
        }
        catch (Exception e) {
            throw new IOException("Error stopping");
        }
    }
}

