/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportException;

class SecureTransport
implements Transport {
    private Transport transport;
    private ByteBuffer output;
    private ByteBuffer input;
    private ByteBuffer swap;
    private SSLEngine engine;
    private boolean closed;

    public SecureTransport(Transport transport, ByteBuffer input, ByteBuffer swap) {
        this(transport, input, swap, 20480);
    }

    public SecureTransport(Transport transport, ByteBuffer input, ByteBuffer swap, int size) {
        this.output = ByteBuffer.allocate(size);
        this.engine = transport.getEngine();
        this.transport = transport;
        this.input = input;
        this.swap = swap;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    public Map getAttributes() {
        return this.transport.getAttributes();
    }

    public SocketChannel getChannel() {
        return this.transport.getChannel();
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        int count = this.fill(buffer);
        if (count <= 0) {
            int size = this.swap.position();
            if (size > 0) {
                this.swap.compact();
            } else {
                this.swap.clear();
            }
            int space = this.swap.remaining();
            if (space > 0) {
                size = this.transport.read(this.swap);
            }
            if (size > 0 || space > 0) {
                this.swap.flip();
                this.receive();
            }
            return this.fill(buffer);
        }
        return count;
    }

    private int fill(ByteBuffer buffer) throws IOException {
        int space = buffer.remaining();
        int count = this.input.position();
        if (count > 0 && count > space) {
            count = space;
        }
        return this.fill(buffer, count);
    }

    private int fill(ByteBuffer buffer, int count) throws IOException {
        this.input.flip();
        if (count > 0) {
            count = this.append(buffer, count);
        }
        this.input.compact();
        return count;
    }

    private int append(ByteBuffer data, int count) throws IOException {
        ByteBuffer segment = this.input.slice();
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        int mark = this.input.position();
        int size = mark + count;
        if (count > 0) {
            this.input.position(size);
            segment.limit(count);
            data.put(segment);
        }
        return count;
    }

    private void receive() throws IOException {
        int count = this.swap.remaining();
        while (count > 0) {
            SSLEngineResult result = this.engine.unwrap(this.swap, this.input);
            SSLEngineResult.Status status = result.getStatus();
            switch (status) {
                case BUFFER_OVERFLOW: 
                case BUFFER_UNDERFLOW: {
                    return;
                }
                case CLOSED: {
                    throw new TransportException("Transport error " + result);
                }
            }
            count = this.swap.remaining();
            if (count > 0) continue;
            break;
        }
    }

    public void write(ByteBuffer data) throws IOException {
        int ready;
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        int capacity = this.output.capacity();
        int length = ready = data.remaining();
        while (ready > 0) {
            int size = Math.min(ready, capacity / 2);
            int mark = data.position();
            if (length * 2 > capacity) {
                data.limit(mark + size);
            }
            this.send(data);
            this.output.clear();
            ready -= size;
        }
    }

    private void send(ByteBuffer data) throws IOException {
        SSLEngineResult result = this.engine.wrap(data, this.output);
        SSLEngineResult.Status status = result.getStatus();
        switch (status) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: 
            case CLOSED: {
                throw new TransportException("Transport error " + (Object)((Object)status));
            }
        }
        this.output.flip();
        this.transport.write(this.output);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new TransportException("Transport is closed");
        }
        this.transport.flush();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.transport.close();
            this.closed = true;
        }
    }
}

