/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.ink.log4j;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.smallmind.scribe.ink.log4j.Log4JLevelTranslator;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LogicalContext;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.adapter.RecordWrapper;
import org.smallmind.scribe.pen.probe.ProbeReport;

public class Log4JRecordFilter
extends LoggingEvent
implements RecordWrapper {
    private FilterRecord filterRecord;
    private AtomicReference<LocationInfo> locationInfoReference;
    private Discriminator discriminator;
    private Level level;

    public Log4JRecordFilter(Record record, Discriminator discriminator, Level level) {
        this(record, (LoggingEvent)record.getNativeLogEntry(), discriminator, level);
    }

    private Log4JRecordFilter(Record record, LoggingEvent loggingEvent, Discriminator discriminator, Level level) {
        super(loggingEvent.getFQNOfLoggerClass(), loggingEvent.getLogger(), loggingEvent.getTimeStamp(), (Priority)Log4JLevelTranslator.getLog4JLevel(level), (Object)loggingEvent.getRenderedMessage(), loggingEvent.getThrowableInformation().getThrowable());
        this.discriminator = discriminator;
        this.level = level;
        this.filterRecord = new FilterRecord(record, this);
        this.locationInfoReference = new AtomicReference();
    }

    public Record getRecord() {
        return this.filterRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationInfo getLocationInformation() {
        if (this.locationInfoReference.get() == null) {
            Log4JRecordFilter log4JRecordFilter = this;
            synchronized (log4JRecordFilter) {
                if (this.locationInfoReference.get() == null && this.filterRecord.getLogicalContext() != null) {
                    this.locationInfoReference.set(new LocationInfo(this.filterRecord.getLogicalContext().getFileName(), this.filterRecord.getLogicalContext().getClassName(), this.filterRecord.getLogicalContext().getMethodName(), String.valueOf(this.filterRecord.getLogicalContext().getLineNumber())));
                }
            }
        }
        return this.locationInfoReference.get();
    }

    private class FilterRecord
    implements Record {
        private Record record;
        private LoggingEvent loggingEvent;

        public FilterRecord(Record record, LoggingEvent loggingEvent) {
            this.record = record;
            this.loggingEvent = loggingEvent;
        }

        public Object getNativeLogEntry() {
            return this.loggingEvent;
        }

        public ProbeReport getProbeReport() {
            return this.record.getProbeReport();
        }

        public String getLoggerName() {
            return this.record.getLoggerName();
        }

        public Discriminator getDiscriminator() {
            return Log4JRecordFilter.this.discriminator;
        }

        public Level getLevel() {
            return Log4JRecordFilter.this.level;
        }

        public Throwable getThrown() {
            return this.record.getThrown();
        }

        public String getMessage() {
            return this.record.getMessage();
        }

        public void addParameter(String key, Serializable value) {
            throw new UnsupportedOperationException();
        }

        public Parameter[] getParameters() {
            return this.record.getParameters();
        }

        public LogicalContext getLogicalContext() {
            return this.record.getLogicalContext();
        }

        public long getThreadID() {
            return this.record.getThreadID();
        }

        public String getThreadName() {
            return this.record.getThreadName();
        }

        public long getSequenceNumber() {
            return this.record.getSequenceNumber();
        }

        public long getMillis() {
            return this.record.getMillis();
        }
    }
}

