/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.scribe.pen.Record;

public class AsynchronousAppender
implements Appender {
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final Appender internalAppender;
    private final LinkedBlockingQueue<Record> publishQueue;
    private final PublishWorker publishWorker;

    public AsynchronousAppender(Appender internalAppender) {
        this(internalAppender, Integer.MAX_VALUE);
    }

    public AsynchronousAppender(Appender internalAppender, int bufferSize) {
        this.internalAppender = internalAppender;
        this.publishQueue = new LinkedBlockingQueue(bufferSize);
        this.publishWorker = new PublishWorker();
        Thread publishThread = new Thread(this.publishWorker);
        publishThread.setDaemon(true);
        publishThread.start();
    }

    @Override
    public String getName() {
        return this.internalAppender.getName();
    }

    @Override
    public void setName(String name) {
        this.internalAppender.setName(name);
    }

    @Override
    public void clearFilters() {
        this.internalAppender.clearFilters();
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.internalAppender.setFilter(filter);
    }

    @Override
    public void addFilter(Filter filter) {
        this.internalAppender.addFilter(filter);
    }

    @Override
    public Filter[] getFilters() {
        return this.internalAppender.getFilters();
    }

    @Override
    public void setFilters(List<Filter> filterList) {
        this.internalAppender.setFilters(filterList);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.internalAppender.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.internalAppender.setErrorHandler(errorHandler);
    }

    @Override
    public Formatter getFormatter() {
        return this.internalAppender.getFormatter();
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this.internalAppender.setFormatter(formatter);
    }

    @Override
    public boolean isActive() {
        return this.internalAppender.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.internalAppender.setActive(active);
    }

    @Override
    public void publish(Record record) {
        try {
            if (this.finished.get()) {
                throw new LoggerException("%s has been previously closed", this.getClass().getSimpleName());
            }
            this.publishQueue.put(record);
        }
        catch (Exception exception) {
            if (this.internalAppender.getErrorHandler() == null) {
                exception.printStackTrace();
            }
            this.internalAppender.getErrorHandler().process(record, exception, "Unable to publish message from appender(%s)", this.getClass().getCanonicalName());
        }
    }

    @Override
    public void close() throws InterruptedException, LoggerException {
        this.publishWorker.finish();
        this.internalAppender.close();
    }

    protected void finalize() throws InterruptedException, LoggerException {
        this.close();
    }

    private class PublishWorker
    implements Runnable {
        private final CountDownLatch exitLatch = new CountDownLatch(1);

        private PublishWorker() {
        }

        private void finish() throws InterruptedException {
            AsynchronousAppender.this.finished.compareAndSet(false, true);
            this.exitLatch.await();
        }

        @Override
        public void run() {
            try {
                try {
                    while (!AsynchronousAppender.this.finished.get()) {
                        Record record = (Record)AsynchronousAppender.this.publishQueue.poll(1L, TimeUnit.SECONDS);
                        if (record == null) continue;
                        AsynchronousAppender.this.internalAppender.publish(record);
                    }
                }
                catch (InterruptedException interruptedException) {
                    AsynchronousAppender.this.finished.set(true);
                    LoggerManager.getLogger(AsynchronousAppender.class).error(interruptedException);
                    this.exitLatch.countDown();
                }
            }
            finally {
                this.exitLatch.countDown();
            }
        }
    }
}

