/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.LoggerRuntimeException;
import org.smallmind.scribe.pen.Template;

public class RegExpTemplate
extends Template {
    private AtomicReference<Pattern> loggerPatternRef = new AtomicReference();

    public RegExpTemplate() {
    }

    public RegExpTemplate(String expression) {
        this.loggerPatternRef.set(Pattern.compile(expression));
    }

    public RegExpTemplate(Level level, boolean autoFillLogicalContext, String expression) throws LoggerException {
        super(level, autoFillLogicalContext);
        this.loggerPatternRef.set(Pattern.compile(expression));
    }

    public RegExpTemplate(Filter[] filters, Appender[] appenders, Enhancer[] enhancers, Level level, boolean autoFillLogicalContext, String expression) throws LoggerException {
        super(filters, appenders, enhancers, level, autoFillLogicalContext);
        this.loggerPatternRef.set(Pattern.compile(expression));
    }

    public void setExpression(String expression) {
        if (!this.loggerPatternRef.compareAndSet(null, Pattern.compile(expression))) {
            throw new LoggerRuntimeException("RegExpTemplate has been previously initialized with a pattern", new Object[0]);
        }
    }

    @Override
    public int matchLogger(String loggerName) {
        if (this.loggerPatternRef.get() == null) {
            throw new LoggerRuntimeException("RegExpTemplate was never initialized with a pattern", new Object[0]);
        }
        return this.loggerPatternRef.get().matcher(loggerName).matches() ? Integer.MAX_VALUE : -1;
    }
}

