/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.smallmind.nutsnbolts.util.DotNotation;
import org.smallmind.nutsnbolts.util.DotNotationException;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.LoggerRuntimeException;
import org.smallmind.scribe.pen.Template;

public class ClassNameTemplate
extends Template {
    private AtomicReference<DotNotation> notationRef = new AtomicReference();

    public ClassNameTemplate() {
    }

    public ClassNameTemplate(String pattern) throws LoggerException {
        try {
            this.notationRef.set(new DotNotation(pattern));
        }
        catch (DotNotationException dotNotationException) {
            throw new LoggerException(dotNotationException);
        }
    }

    public ClassNameTemplate(Level level, boolean autoFillLogicalContext, String pattern) throws LoggerException {
        super(level, autoFillLogicalContext);
        try {
            this.notationRef.set(new DotNotation(pattern));
        }
        catch (DotNotationException dotNotationException) {
            throw new LoggerException(dotNotationException);
        }
    }

    public ClassNameTemplate(Filter[] filters, Appender[] appenders, Enhancer[] enhancers, Level level, boolean autoFillLogicalContext, String pattern) throws LoggerException {
        super(filters, appenders, enhancers, level, autoFillLogicalContext);
        try {
            this.notationRef.set(new DotNotation(pattern));
        }
        catch (DotNotationException dotNotationException) {
            throw new LoggerException(dotNotationException);
        }
    }

    private static int assignValueToMatch(Integer[] dotPositions, int matchStart) {
        int index = 0;
        Integer[] integerArray = dotPositions;
        int n = dotPositions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer dotPosition = integerArray[n2];
            if (dotPosition > matchStart) break;
            ++index;
            ++n2;
        }
        return (int)Math.pow(2.0, index);
    }

    private static Integer[] getDotPositions(String loggerName) {
        LinkedList<Integer> dotPositionList = new LinkedList<Integer>();
        int count = 0;
        while (count < loggerName.length()) {
            if (loggerName.charAt(count) == '.') {
                dotPositionList.add(count);
            }
            ++count;
        }
        Integer[] dotPosiitions = new Integer[dotPositionList.size()];
        dotPositionList.toArray(dotPosiitions);
        return dotPosiitions;
    }

    public void setPattern(String pattern) throws LoggerException {
        try {
            if (!this.notationRef.compareAndSet(null, new DotNotation(pattern))) {
                throw new LoggerRuntimeException("ClassNameTemplate has been previously initialized with a pattern", new Object[0]);
            }
        }
        catch (DotNotationException dotNotationException) {
            throw new LoggerException(dotNotationException);
        }
    }

    @Override
    public int matchLogger(String loggerName) {
        int matchValue = -1;
        if (this.notationRef.get() == null) {
            throw new LoggerRuntimeException("ClassNameTemplate was never initialized with a pattern", new Object[0]);
        }
        Integer[] dotPositions = ClassNameTemplate.getDotPositions(loggerName);
        Matcher matcher = this.notationRef.get().getPattern().matcher(loggerName);
        if (matcher.matches()) {
            matchValue += 2;
            int count = 1;
            while (count <= matcher.groupCount()) {
                matchValue += ClassNameTemplate.assignValueToMatch(dotPositions, matcher.start(count));
                ++count;
            }
        }
        return matchValue;
    }
}

