/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.smallmind.nutsnbolts.io.PathUtility;
import org.smallmind.scribe.pen.AbstractFormattedAppender;
import org.smallmind.scribe.pen.Cleanup;
import org.smallmind.scribe.pen.ErrorHandler;
import org.smallmind.scribe.pen.Formatter;
import org.smallmind.scribe.pen.LoggerException;
import org.smallmind.scribe.pen.Rollover;

public class FileAppender
extends AbstractFormattedAppender {
    private OutputStream fileOutputStream;
    private Path logPath;
    private Cleanup cleanup;
    private Rollover rollover;
    private boolean closed = false;
    private long fileSize = 0L;
    private long lastModified = 0L;

    public FileAppender() {
    }

    public FileAppender(String logFile) throws IOException {
        this(Paths.get(logFile, new String[0]), null, null, null, null);
    }

    public FileAppender(Path logPath) throws IOException {
        this(logPath, null, null, null, null);
    }

    public FileAppender(String logFile, Rollover rollover) throws IOException {
        this(Paths.get(logFile, new String[0]), rollover, null, null, null);
    }

    public FileAppender(Path logPath, Rollover rollover) throws IOException {
        this(logPath, rollover, null, null, null);
    }

    public FileAppender(String logFile, Cleanup cleanup) throws IOException {
        this(Paths.get(logFile, new String[0]), null, cleanup, null, null);
    }

    public FileAppender(Path logPath, Cleanup cleanup) throws IOException {
        this(logPath, null, cleanup, null, null);
    }

    public FileAppender(String logFile, Formatter formatter) throws IOException {
        this(Paths.get(logFile, new String[0]), null, null, formatter, null);
    }

    public FileAppender(Path logPath, Formatter formatter) throws IOException {
        this(logPath, null, null, formatter, null);
    }

    public FileAppender(String logFile, Rollover rollover, Formatter formatter) throws IOException {
        this(Paths.get(logFile, new String[0]), rollover, null, formatter, null);
    }

    public FileAppender(Path logPath, Rollover rollover, Formatter formatter) throws IOException {
        this(logPath, rollover, null, formatter, null);
    }

    public FileAppender(String logFile, Cleanup cleanup, Formatter formatter) throws IOException {
        this(Paths.get(logFile, new String[0]), null, cleanup, formatter, null);
    }

    public FileAppender(Path logPath, Cleanup cleanup, Formatter formatter) throws IOException {
        this(logPath, null, cleanup, formatter, null);
    }

    public FileAppender(String logFile, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(Paths.get(logFile, new String[0]), null, null, formatter, errorHandler);
    }

    public FileAppender(Path logPath, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(logPath, null, null, formatter, errorHandler);
    }

    public FileAppender(String logFile, Rollover rollover, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(Paths.get(logFile, new String[0]), rollover, null, formatter, errorHandler);
    }

    public FileAppender(Path logPath, Rollover rollover, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(logPath, rollover, null, formatter, errorHandler);
    }

    public FileAppender(String logFile, Cleanup cleanup, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(Paths.get(logFile, new String[0]), null, cleanup, formatter, errorHandler);
    }

    public FileAppender(Path logPath, Cleanup cleanup, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(logPath, null, cleanup, formatter, errorHandler);
    }

    public FileAppender(String logFile, Rollover rollover, Cleanup cleanup, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        this(Paths.get(logFile, new String[0]), rollover, cleanup, formatter, errorHandler);
    }

    public FileAppender(Path logPath, Rollover rollover, Cleanup cleanup, Formatter formatter, ErrorHandler errorHandler) throws IOException {
        super(formatter, errorHandler);
        this.rollover = rollover;
        this.setLogPath(logPath);
    }

    public Rollover getRollover() {
        return this.rollover;
    }

    public void setRollover(Rollover rollover) {
        this.rollover = rollover;
    }

    public Cleanup getCleanup() {
        return this.cleanup;
    }

    public void setCleanup(Cleanup cleanup) {
        this.cleanup = cleanup;
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public void setLogPath(Path logPath) throws IOException {
        this.logPath = logPath;
        if (Files.isDirectory(logPath, new LinkOption[0])) {
            throw new IOException("File must specify a non-directory path(" + logPath.toAbsolutePath() + ")");
        }
        Path parentPath = logPath.getParent();
        if (parentPath != null) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        this.openStream();
    }

    public void setLogFile(String logFile) throws IOException {
        this.setLogPath(Paths.get(logFile, new String[0]));
    }

    private void openStream() throws IOException {
        this.fileOutputStream = Files.newOutputStream(this.logPath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        this.lastModified = Files.getLastModifiedTime(this.logPath, new LinkOption[0]).toMillis();
        this.fileSize = 0L;
    }

    @Override
    public synchronized void handleOutput(String formattedOutput) throws LoggerException {
        byte[] formattedBytes = formattedOutput.getBytes();
        if (this.closed) {
            throw new LoggerException("Appender to file(%s) has been previously closed", this.logPath.toAbsolutePath());
        }
        if (this.fileOutputStream != null) {
            if (this.rollover != null && this.rollover.willRollover(this.fileSize, this.lastModified, formattedBytes.length)) {
                StringBuilder uniqueNameBuilder;
                Path rolloverPath;
                Path parentPath = this.logPath.getParent();
                int uniqueCount = 0;
                StringBuilder rolloverNameBuilder = new StringBuilder();
                String logFileName = PathUtility.fileNameAsString((Path)this.logPath);
                int dotPos = logFileName.lastIndexOf(46);
                if (dotPos >= 0) {
                    rolloverNameBuilder.append(logFileName.substring(0, dotPos));
                } else {
                    rolloverNameBuilder.append(logFileName);
                }
                rolloverNameBuilder.append(this.rollover.getSeparator());
                rolloverNameBuilder.append(this.rollover.getTimestampSuffix(new Date()));
                do {
                    uniqueNameBuilder = new StringBuilder(rolloverNameBuilder);
                    uniqueNameBuilder.append(this.rollover.getSeparator());
                    uniqueNameBuilder.append(uniqueCount++);
                    if (dotPos < 0) continue;
                    uniqueNameBuilder.append(logFileName.substring(dotPos));
                } while (Files.exists(rolloverPath = parentPath == null ? Paths.get(uniqueNameBuilder.toString(), new String[0]) : parentPath.resolve(uniqueNameBuilder.toString()), new LinkOption[0]));
                try {
                    this.fileOutputStream.close();
                }
                catch (IOException ioException) {
                    throw new LoggerException(ioException, "Unable to close the current log file(%s)", this.logPath.toAbsolutePath());
                }
                try {
                    Files.move(this.logPath, rolloverPath, new CopyOption[0]);
                }
                catch (IOException ioException) {
                    throw new LoggerException(ioException, "Could not rollover the log file to the archive name(%s)", rolloverPath.toAbsolutePath());
                }
                try {
                    this.openStream();
                }
                catch (IOException ioException) {
                    throw new LoggerException(ioException, "Unable to create the new log file(%s)", this.logPath.toAbsolutePath());
                }
                if (this.cleanup != null) {
                    try {
                        this.cleanup.vacuum(this.logPath);
                    }
                    catch (IOException ioException) {
                        throw new LoggerException(ioException);
                    }
                }
            }
            try {
                this.fileOutputStream.write(formattedBytes);
                this.fileOutputStream.flush();
                this.fileSize += (long)formattedBytes.length;
                this.lastModified = System.currentTimeMillis();
            }
            catch (IOException ioException) {
                throw new LoggerException(ioException, "Error attempting to output to file(%s)", this.logPath.toAbsolutePath());
            }
        }
    }

    @Override
    public synchronized void close() throws LoggerException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.fileOutputStream.close();
            }
            catch (IOException ioException) {
                throw new LoggerException(ioException);
            }
        }
    }

    public void finalize() throws LoggerException {
        this.close();
    }
}

