/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.scribe.pen.RolloverRule;
import org.smallmind.scribe.pen.TimestampQuantifier;

public class TimestampRolloverRule
implements RolloverRule {
    private TimestampQuantifier timestampQuantifier;

    public TimestampRolloverRule() {
        this(TimestampQuantifier.TOP_OF_DAY);
    }

    public TimestampRolloverRule(TimestampQuantifier timestampQuantifier) {
        this.timestampQuantifier = timestampQuantifier;
    }

    public TimestampQuantifier getTimestampQuantifier() {
        return this.timestampQuantifier;
    }

    public void setTimestampQuantifier(TimestampQuantifier timestampQuantifier) {
        this.timestampQuantifier = timestampQuantifier;
    }

    @Override
    public boolean willRollover(long fileSize, long lastModifiedTimeified, long bytesToBeWritten) {
        ZonedDateTime lastModifiedTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastModifiedTimeified), ZoneId.systemDefault());
        ZonedDateTime now = ZonedDateTime.now();
        switch (this.timestampQuantifier) {
            case TOP_OF_MINUTE: {
                return now.getYear() != lastModifiedTime.getYear() || now.getMonthValue() != lastModifiedTime.getMonthValue() || now.getDayOfMonth() != lastModifiedTime.getDayOfMonth() || now.getHour() != lastModifiedTime.getHour() || now.getMinute() != lastModifiedTime.getMinute();
            }
            case TOP_OF_HOUR: {
                return now.getYear() != lastModifiedTime.getYear() || now.getMonthValue() != lastModifiedTime.getMonthValue() || now.getDayOfMonth() != lastModifiedTime.getDayOfMonth() || now.getHour() != lastModifiedTime.getHour();
            }
            case HALF_DAY: {
                return now.getYear() != lastModifiedTime.getYear() || now.getMonthValue() != lastModifiedTime.getMonthValue() || now.getDayOfMonth() != lastModifiedTime.getDayOfMonth() || now.get(ChronoField.AMPM_OF_DAY) != lastModifiedTime.get(ChronoField.AMPM_OF_DAY);
            }
            case TOP_OF_DAY: {
                return now.getYear() != lastModifiedTime.getYear() || now.getMonthValue() != lastModifiedTime.getMonthValue() || now.getDayOfMonth() != lastModifiedTime.getDayOfMonth();
            }
            case TOP_OF_WEEK: {
                return now.getYear() != lastModifiedTime.getYear() || now.getMonthValue() != lastModifiedTime.getMonthValue() || now.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) != lastModifiedTime.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
            }
            case TOP_OF_MONTH: {
                return now.getYear() != lastModifiedTime.getYear() || now.getMonthValue() != lastModifiedTime.getMonthValue();
            }
        }
        throw new UnknownSwitchCaseException(this.timestampQuantifier.name(), new Object[0]);
    }
}

