/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.instrument.Clock;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.ExponentiallyWeightedMovingAverage;
import org.smallmind.instrument.Meter;
import org.smallmind.instrument.MetricImpl;
import org.smallmind.instrument.context.MetricFact;
import org.smallmind.instrument.context.MetricItem;
import org.smallmind.instrument.context.MetricSnapshot;
import org.smallmind.nutsnbolts.time.TimeUtilities;

public class MeterImpl
extends MetricImpl<Meter>
implements Meter {
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final ExponentiallyWeightedMovingAverage m1Average;
    private final ExponentiallyWeightedMovingAverage m5Average;
    private final ExponentiallyWeightedMovingAverage m15Average;
    private final ScheduledFuture<?> future;
    private final AtomicLong startTime;
    private final AtomicLong count = new AtomicLong(0L);
    private final Clock clock;
    private final TimeUnit tickTimeUnit;

    public MeterImpl() {
        this(5L, TimeUnit.SECONDS, Clocks.EPOCH.getClock());
    }

    public MeterImpl(long tickInterval, TimeUnit tickTimeUnit) {
        this(tickInterval, tickTimeUnit, Clocks.EPOCH.getClock());
    }

    public MeterImpl(long tickInterval, TimeUnit tickTimeUnit, Clock clock) {
        this.tickTimeUnit = tickTimeUnit;
        this.clock = clock;
        this.startTime = new AtomicLong(clock.getTimeMilliseconds());
        this.m1Average = ExponentiallyWeightedMovingAverage.lastOneMinute(tickInterval, tickTimeUnit);
        this.m5Average = ExponentiallyWeightedMovingAverage.lastFiveMinutes(tickInterval, tickTimeUnit);
        this.m15Average = ExponentiallyWeightedMovingAverage.lastFifteenMinutes(tickInterval, tickTimeUnit);
        this.future = SCHEDULED_EXECUTOR.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                MeterImpl.this.m1Average.tick();
                MeterImpl.this.m5Average.tick();
                MeterImpl.this.m15Average.tick();
            }
        }, tickInterval, tickInterval, tickTimeUnit);
    }

    @Override
    public Class<Meter> getMetricClass() {
        return Meter.class;
    }

    @Override
    public void clear() {
        this.startTime.set(this.clock.getTimeMilliseconds());
        this.count.set(0L);
        this.m15Average.clear();
        this.m15Average.clear();
        this.m15Average.clear();
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            if (metricSnapshot.willTrace(MetricFact.COUNT)) {
                metricSnapshot.addItem(new MetricItem<Long>("count", 0L));
            }
            if (metricSnapshot.willTrace(MetricFact.M1_AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("1 min avg", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.M5_AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("5 min avg", 0.0));
            }
            if (metricSnapshot.willTrace(MetricFact.M15_AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("15 min avg", 0.0));
            }
        }
    }

    @Override
    public void mark() {
        this.mark(1L);
    }

    @Override
    public void mark(long n) {
        long current = this.count.addAndGet(n);
        this.m1Average.update(n);
        this.m5Average.update(n);
        this.m15Average.update(n);
        MetricSnapshot metricSnapshot = this.getMetricSnapshot();
        if (metricSnapshot != null) {
            if (metricSnapshot.willTrace(MetricFact.COUNT)) {
                metricSnapshot.addItem(new MetricItem<Long>("count", current));
            }
            if (metricSnapshot.willTrace(MetricFact.M1_AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("1 min avg", this.m1Average.getMovingAverage(this.tickTimeUnit)));
            }
            if (metricSnapshot.willTrace(MetricFact.M5_AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("5 min avg", this.m5Average.getMovingAverage(this.tickTimeUnit)));
            }
            if (metricSnapshot.willTrace(MetricFact.M15_AVG)) {
                metricSnapshot.addItem(new MetricItem<Double>("15 min avg", this.m15Average.getMovingAverage(this.tickTimeUnit)));
            }
        }
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    public TimeUnit getRateTimeUnit() {
        return this.tickTimeUnit;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public double getOneMinuteAvgRate() {
        return this.m1Average.getMovingAverage(this.tickTimeUnit);
    }

    @Override
    public double getFiveMinuteAvgRate() {
        return this.m5Average.getMovingAverage(this.tickTimeUnit);
    }

    @Override
    public double getFifteenMinuteAvgRate() {
        return this.m15Average.getMovingAverage(this.tickTimeUnit);
    }

    @Override
    public double getAverageRate() {
        long currentCount = this.count.get();
        if (currentCount == 0L) {
            return 0.0;
        }
        return (double)currentCount / (double)(this.clock.getTimeMilliseconds() - this.startTime.get()) * TimeUtilities.convertToDouble((long)1L, (TimeUnit)this.tickTimeUnit, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.future.cancel(false);
    }
}

