/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.instrument.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.Metric;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.context.MetricAddress;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.instrument.event.MetricEvent;

public abstract class NamedMetric<M extends Metric<M>>
implements InvocationHandler {
    private M metric;
    private M proxyMetric;
    private MetricAddress metricAddress;

    public NamedMetric(M metric, String domain, MetricProperty ... properties) {
        this.metric = metric;
        this.metricAddress = new MetricAddress(domain, properties);
        this.proxyMetric = (Metric)metric.getMetricClass().cast(Proxy.newProxyInstance(NamedMetric.class.getClassLoader(), new Class[]{metric.getMetricClass()}, (InvocationHandler)this));
    }

    public abstract Method[] getUpdatingMethods();

    public M getProxy() {
        return this.proxyMetric;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean pushed = false;
        MetricContext metricContext = InstrumentationManager.getMetricContext();
        if (metricContext != null) {
            Method[] methodArray = this.getUpdatingMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method updatingMethod = methodArray[n2];
                if (method.equals(updatingMethod)) {
                    pushed = metricContext.pushSnapshot(this.metricAddress);
                    break;
                }
                ++n2;
            }
        }
        try {
            Object result = method.invoke(this.metric, args);
            InstrumentationManager.getMetricRegistry().fireMetricEvent(new MetricEvent((Metric)this.metric, this.metricAddress, method, args));
            Object object = result;
            return object;
        }
        finally {
            if (pushed) {
                metricContext.popSnapshot();
            }
        }
    }
}

