/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.fault;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.smallmind.web.jersey.util.JsonCodec;

@XmlRootElement(name="information")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class FaultInformation
implements Serializable {
    private Object[] arguments;
    private String template;
    private int code;

    public FaultInformation() {
    }

    public FaultInformation(int code, String template, Object ... arguments) {
        this.code = code;
        this.template = template;
        this.arguments = arguments;
    }

    @XmlElement(name="code")
    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @XmlElement(name="template")
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @XmlTransient
    public Object[] getArgumentsAs(Class<?>[] classes) {
        if (this.arguments == null || (classes == null ? 0 : classes.length) != this.arguments.length) {
            throw new IllegalArgumentException("The number of classes(" + (classes == null ? 0 : classes.length) + ") must match the number of arguments(" + (this.arguments == null ? 0 : this.arguments.length) + ")");
        }
        Object[] convertedArguments = new Object[this.arguments.length];
        int index = 0;
        while (index < this.arguments.length) {
            convertedArguments[index] = JsonCodec.convert(this.arguments[index], classes[index]);
            ++index;
        }
        return convertedArguments;
    }

    @XmlTransient
    public <T> T getArgumentAs(int index, Class<T> clazz) {
        if (index < 0 || this.arguments == null || index >= this.arguments.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + ">" + (this.arguments == null ? 0 : this.arguments.length));
        }
        return JsonCodec.convert(this.arguments[index], clazz);
    }

    @XmlElement(name="arguments")
    @XmlAnyElement
    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }
}

