/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jetty;

import com.sun.net.httpserver.HttpContext;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.xml.ws.Endpoint;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.spi.JettyHttpServer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.smallmind.nutsnbolts.lang.web.PerApplicationContextFilter;
import org.smallmind.nutsnbolts.resource.ResourceException;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.web.jersey.spring.ExposedApplicationContext;
import org.smallmind.web.jersey.spring.JerseyResourceConfig;
import org.smallmind.web.jersey.spring.ResourceConfigExtension;
import org.smallmind.web.jetty.ByteArrayResource;
import org.smallmind.web.jetty.FilterInstaller;
import org.smallmind.web.jetty.JettyInitializationException;
import org.smallmind.web.jetty.JettyRequestContextListener;
import org.smallmind.web.jetty.ListenerInstaller;
import org.smallmind.web.jetty.SSLInfo;
import org.smallmind.web.jetty.ServicePath;
import org.smallmind.web.jetty.ServletInstaller;
import org.smallmind.web.jetty.WebServiceInstaller;
import org.smallmind.web.jetty.option.ClassLoaderResourceOption;
import org.smallmind.web.jetty.option.DocumentRootOption;
import org.smallmind.web.jetty.option.JaxRSOption;
import org.smallmind.web.jetty.option.SpringSupportOption;
import org.smallmind.web.jetty.option.WebSocketOption;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class JettyInitializingBean
implements DisposableBean,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
BeanPostProcessor {
    private Server server;
    private LinkedList<WebServiceInstaller> webServiceInstallerList = new LinkedList();
    private LinkedList<ListenerInstaller> listenerInstallerList = new LinkedList();
    private LinkedList<FilterInstaller> filterInstallerList = new LinkedList();
    private LinkedList<ServletInstaller> servletInstallerList = new LinkedList();
    private ResourceConfigExtension[] resourceConfigExtensions;
    private ClassLoaderResourceOption classLoaderResourceOption;
    private DocumentRootOption documentRootOption;
    private JaxRSOption jaxRSOption;
    private SpringSupportOption springSupportOption;
    private WebSocketOption webSocketOption;
    private SSLInfo sslInfo;
    private String host;
    private String contextPath = "/context";
    private String soapPath = "/soap";
    private Integer maxHttpHeaderSize;
    private Integer initialWorkerPoolSize;
    private Integer maximumWorkerPoolSize;
    private int port = 80;
    private boolean allowInsecure = true;
    private boolean debug = false;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClassLoaderResourceOption(ClassLoaderResourceOption classLoaderResourceOption) {
        this.classLoaderResourceOption = classLoaderResourceOption;
    }

    public void setDocumentRootOption(DocumentRootOption documentRootOption) {
        this.documentRootOption = documentRootOption;
    }

    public void setJaxRSOption(JaxRSOption jaxRSOption) {
        this.jaxRSOption = jaxRSOption;
    }

    public void setSpringSupportOption(SpringSupportOption springSupportOption) {
        this.springSupportOption = springSupportOption;
    }

    public void setWebSocketOption(WebSocketOption webSocketOption) {
        this.webSocketOption = webSocketOption;
    }

    public void setSslInfo(SSLInfo sslInfo) {
        this.sslInfo = sslInfo;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = this.normalizePath(contextPath);
    }

    public void setSoapPath(String soapPath) {
        this.soapPath = this.normalizePath(soapPath);
    }

    public void setResourceConfigExtensions(ResourceConfigExtension[] resourceConfigExtensions) {
        this.resourceConfigExtensions = resourceConfigExtensions;
    }

    public void setInitialWorkerPoolSize(Integer initialWorkerPoolSize) {
        this.initialWorkerPoolSize = initialWorkerPoolSize;
    }

    public void setMaximumWorkerPoolSize(Integer maximumWorkerPoolSize) {
        this.maximumWorkerPoolSize = maximumWorkerPoolSize;
    }

    public void setMaxHttpHeaderSize(Integer maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setAllowInsecure(boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        ExposedApplicationContext.register((ApplicationContext)applicationContext);
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        HttpConfiguration httpConfig = new HttpConfiguration();
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        if (this.debug) {
            System.setProperty("com.sun.xml.ws.transport.http.HttpAdapter.dump", "true");
        }
        if (this.initialWorkerPoolSize != null) {
            threadPool.setMinThreads(this.initialWorkerPoolSize.intValue());
        }
        if (this.maximumWorkerPoolSize != null) {
            threadPool.setMaxThreads(this.maximumWorkerPoolSize.intValue());
        }
        this.server = new Server((ThreadPool)threadPool);
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setSendServerVersion(true);
        httpConfig.setSendDateHeader(false);
        if (this.maxHttpHeaderSize != null) {
            httpConfig.setRequestHeaderSize(this.maxHttpHeaderSize.intValue());
            httpConfig.setResponseHeaderSize(this.maxHttpHeaderSize.intValue());
        }
        if (this.sslInfo != null) {
            SslContextFactory.Server server = new SslContextFactory.Server();
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.setSecureScheme("https");
            httpsConfig.setSecurePort(this.sslInfo.getPort());
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            server.setKeyStorePassword(this.sslInfo.getKeySSLStore().getPassword());
            try {
                server.setKeyStoreResource((Resource)new ByteArrayResource(this.sslInfo.getKeySSLStore().getBytes()));
            }
            catch (IOException | ResourceException exception) {
                throw new JettyInitializationException(exception);
            }
            server.setTrustStorePassword(this.sslInfo.getTrustSSLStore().getPassword());
            try {
                server.setTrustStoreResource((Resource)new ByteArrayResource(this.sslInfo.getTrustSSLStore().getBytes()));
            }
            catch (IOException | ResourceException exception) {
                throw new JettyInitializationException(exception);
            }
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)server, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            sslConnector.setHost(this.host);
            sslConnector.setPort(this.sslInfo.getPort());
            this.server.addConnector((Connector)sslConnector);
        }
        if (this.allowInsecure) {
            ServerConnector httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            httpConnector.setHost(this.host);
            httpConnector.setPort(this.port);
            this.server.addConnector((Connector)httpConnector);
        } else if (this.sslInfo == null) {
            throw new JettyInitializationException("Instance is not configured to allow insecure connection, and does not provide any ssl info", new Object[0]);
        }
        this.server.setHandler((Handler)contextHandlerCollection);
        if (this.classLoaderResourceOption != null) {
            ContextHandler staticContextHandler = new ContextHandler(this.combinePaths(this.contextPath, this.classLoaderResourceOption.getStaticPath()));
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setBaseResource(Resource.newClassPathResource((String)"/"));
            staticContextHandler.setHandler((Handler)resourceHandler);
            contextHandlerCollection.addHandler((Handler)staticContextHandler);
        }
        if (this.documentRootOption != null) {
            for (Map.Entry entry : this.documentRootOption.getDocumentRoots().entrySet()) {
                ContextHandler documentContextHandler = new ContextHandler(this.combinePaths(this.combinePaths(this.contextPath, this.documentRootOption.getDocumentPath()), this.normalizePath((String)entry.getKey())));
                ResourceHandler documentResourceHandler = new ResourceHandler();
                documentResourceHandler.setBaseResource((Resource)new PathResource(Paths.get((String)entry.getValue(), new String[0])));
                documentContextHandler.setHandler((Handler)documentContextHandler);
                contextHandlerCollection.addHandler((Handler)documentContextHandler);
            }
        }
        if (!this.webServiceInstallerList.isEmpty()) {
            JettyHttpServer jettyHttpServer = new JettyHttpServer(this.server, true);
            for (WebServiceInstaller webServiceInstaller : this.webServiceInstallerList) {
                HttpContext httpContext = jettyHttpServer.createContext(this.combinePaths(this.combinePaths(this.contextPath, this.soapPath), this.normalizePath(webServiceInstaller.getPath())));
                Endpoint endpoint = Endpoint.create((Object)webServiceInstaller.getService());
                endpoint.publish((Object)httpContext);
            }
        }
        if (!(this.listenerInstallerList.isEmpty() && this.filterInstallerList.isEmpty() && this.servletInstallerList.isEmpty() && this.jaxRSOption == null && this.springSupportOption == null && this.webSocketOption == null)) {
            String urlPattern;
            ServletContextHandler servletContextHandler = new ServletContextHandler(0);
            servletContextHandler.setContextPath(this.contextPath);
            for (ListenerInstaller listenerInstaller : this.listenerInstallerList) {
                try {
                    servletContextHandler.addEventListener(listenerInstaller.getListener());
                }
                catch (IllegalAccessException | InstantiationException exception) {
                    throw new JettyInitializationException(exception);
                }
            }
            for (FilterInstaller filterInstaller : this.filterInstallerList) {
                try {
                    FilterHolder filterHolder = new FilterHolder(filterInstaller.getFilter());
                    filterHolder.setName(filterInstaller.getDisplayName());
                    filterHolder.setDisplayName(filterInstaller.getDisplayName());
                    if (filterInstaller.getAsyncSupported() != null) {
                        filterHolder.setAsyncSupported(filterInstaller.getAsyncSupported().booleanValue());
                    }
                    if (filterInstaller.getInitParameters() != null) {
                        filterHolder.setInitParameters(filterInstaller.getInitParameters());
                    }
                    servletContextHandler.addFilter(filterHolder, (urlPattern = filterInstaller.getUrlPattern()) == null ? "/*" : urlPattern, EnumSet.of(DispatcherType.REQUEST));
                }
                catch (IllegalAccessException | InstantiationException exception) {
                    throw new JettyInitializationException(exception);
                }
            }
            for (ServletInstaller servletInstaller : this.servletInstallerList) {
                try {
                    ServletHolder servletHolder = new ServletHolder(servletInstaller.getServlet());
                    servletHolder.setName(servletInstaller.getDisplayName());
                    servletHolder.setDisplayName(servletInstaller.getDisplayName());
                    if (servletInstaller.getLoadOnStartup() != null) {
                        servletHolder.setInitOrder(servletInstaller.getLoadOnStartup().intValue());
                    }
                    if (servletInstaller.getAsyncSupported() != null) {
                        servletHolder.setAsyncSupported(servletInstaller.getAsyncSupported().booleanValue());
                    }
                    if (servletInstaller.getInitParameters() != null) {
                        servletHolder.setInitParameters(servletInstaller.getInitParameters());
                    }
                    servletContextHandler.addServlet(servletHolder, (urlPattern = servletInstaller.getUrlPattern()) == null ? "/*" : urlPattern);
                }
                catch (IllegalAccessException | InstantiationException exception) {
                    throw new JettyInitializationException(exception);
                }
            }
            if (this.jaxRSOption != null) {
                ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new JerseyResourceConfig(ExposedApplicationContext.getApplicationContext(), this.resourceConfigExtensions)));
                FilterHolder jerseyFilterHolder = new FilterHolder((Filter)new PerApplicationContextFilter());
                servletHolder.setName("JAX-RS Application");
                servletHolder.setDisplayName("JAX-RS Application");
                jerseyFilterHolder.setName("per-application-data");
                jerseyFilterHolder.setDisplayName("per-application-data");
                servletContextHandler.addServlet(servletHolder, this.jaxRSOption.getRestPath() + "/*");
                servletContextHandler.addFilter(jerseyFilterHolder, this.jaxRSOption.getRestPath() + "/*", EnumSet.of(DispatcherType.REQUEST));
            }
            if (this.springSupportOption != null) {
                servletContextHandler.addEventListener((EventListener)((Object)new JettyRequestContextListener()));
            }
            if (this.webSocketOption != null) {
                try {
                    WebSocketServerContainerInitializer.configureContext((ServletContextHandler)servletContextHandler);
                }
                catch (ServletException servletException) {
                    throw new JettyInitializationException(servletException);
                }
            }
            contextHandlerCollection.addHandler((Handler)servletContextHandler);
        }
        try {
            this.server.start();
            LoggerManager.getLogger(JettyInitializingBean.class).info((Object)"Jetty service started...");
        }
        catch (Exception exception) {
            throw new JettyInitializationException(exception);
        }
    }

    private String normalizePath(String path) {
        if (path != null) {
            if (path.length() == 0) {
                return "/";
            }
            if (path.length() > 1 && path.endsWith("/")) {
                return path.charAt(0) != '/' ? '/' + path.substring(0, path.length() - 1) : path.substring(0, path.length() - 1);
            }
            return path.charAt(0) != '/' ? '/' + path : path;
        }
        return null;
    }

    private String combinePaths(String contextPath, String extensionPath) {
        return extensionPath == null || extensionPath.isEmpty() || "/".equals(extensionPath) ? contextPath : (contextPath == null || contextPath.isEmpty() || "/".equals(contextPath) ? extensionPath : contextPath + extensionPath);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof ListenerInstaller) {
            this.listenerInstallerList.add((ListenerInstaller)bean);
        } else if (bean instanceof FilterInstaller) {
            this.filterInstallerList.add((FilterInstaller)bean);
        } else if (bean instanceof ServletInstaller) {
            this.servletInstallerList.add((ServletInstaller)bean);
        } else {
            ServicePath servicePath = bean.getClass().getAnnotation(ServicePath.class);
            if (servicePath != null) {
                this.webServiceInstallerList.add(new WebServiceInstaller(servicePath.value(), bean));
            }
        }
        return bean;
    }

    public synchronized void destroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                LoggerManager.getLogger(JettyInitializingBean.class).error((Throwable)exception);
            }
        }
    }
}

