/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.endpoint;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonarsource.scanner.lib.internal.endpoint.ScannerEndpoint;

public enum OfficialSonarQubeCloudInstance {
    GLOBAL("https://sonarcloud.io", "https://api.sonarcloud.io", null),
    US("https://sonarqube.us", "https://api.sonarqube.us", "US");

    private final ScannerEndpoint endpoint;

    private OfficialSonarQubeCloudInstance(@Nullable String webEndpoint, String apiEndpoint, String regionLabel) {
        this.endpoint = new ScannerEndpoint(webEndpoint, apiEndpoint, true, regionLabel);
    }

    public static Set<String> getRegionCodesWithoutGlobal() {
        return OfficialSonarQubeCloudInstance.getRegionsWithoutGlobal().map(Enum::name).map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
    }

    private static Stream<OfficialSonarQubeCloudInstance> getRegionsWithoutGlobal() {
        return Arrays.stream(OfficialSonarQubeCloudInstance.values()).filter(r -> r != GLOBAL);
    }

    public static Optional<OfficialSonarQubeCloudInstance> fromRegionCode(@Nullable String regionCode) {
        if (StringUtils.isBlank((CharSequence)regionCode)) {
            return Optional.of(GLOBAL);
        }
        try {
            OfficialSonarQubeCloudInstance value = OfficialSonarQubeCloudInstance.valueOf(regionCode.toUpperCase(Locale.ENGLISH));
            if (value == GLOBAL) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static Optional<OfficialSonarQubeCloudInstance> fromWebEndpoint(String url) {
        return Arrays.stream(OfficialSonarQubeCloudInstance.values()).filter(r -> r.endpoint.getWebEndpoint().equals(url)).findFirst();
    }

    public ScannerEndpoint getEndpoint() {
        return this.endpoint;
    }
}

