/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.simulation;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.facade.AbstractScannerEngineFacade;

public class SimulationScannerEngineFacade
extends AbstractScannerEngineFacade {
    private static final Logger LOG = LoggerFactory.getLogger(SimulationScannerEngineFacade.class);

    public SimulationScannerEngineFacade(Map<String, String> bootstrapProperties, boolean isSonarCloud, @Nullable String serverVersion) {
        super(bootstrapProperties, isSonarCloud, serverVersion, false, null);
    }

    @Override
    protected boolean doAnalyze(Map<String, String> allProps) {
        String filePath = allProps.get("sonar.scanner.internal.dumpToFile");
        SimulationScannerEngineFacade.writeProperties(filePath, allProps);
        LOG.info("Simulation mode. Configuration written to {}", (Object)new File(filePath).getAbsolutePath());
        return true;
    }

    private static void writeProperties(String filePath, Map<String, String> p) {
        Properties props = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        props.putAll(p);
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            props.store(outputStream, "# Generated by a SonarScanner");
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to export scanner properties", e);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

