/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.X509TrustManager;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.exception.GenericKeyStoreException;
import nl.altindag.ssl.util.KeyStoreUtils;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.http.HttpConfig;
import org.sonarsource.scanner.lib.internal.http.ssl.CertificateStore;
import org.sonarsource.scanner.lib.internal.http.ssl.SslConfig;

public class OkHttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpClientFactory.class);
    static final CookieManager COOKIE_MANAGER = new CookieManager();
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final JavaNetCookieJar COOKIE_JAR;
    public static final String BC_IGNORE_USELESS_PASSWD = "org.bouncycastle.pkcs12.ignore_useless_passwd";

    private OkHttpClientFactory() {
    }

    static OkHttpClient create(HttpConfig httpConfig) {
        SSLFactory sslContext = OkHttpClientFactory.configureSsl(httpConfig.getSslConfig(), httpConfig.skipSystemTruststore());
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout(httpConfig.getConnectTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(httpConfig.getSocketTimeout().toMillis(), TimeUnit.MILLISECONDS).callTimeout(httpConfig.getResponseTimeout().toMillis(), TimeUnit.MILLISECONDS).cookieJar((CookieJar)COOKIE_JAR).sslSocketFactory(sslContext.getSslSocketFactory(), (X509TrustManager)sslContext.getTrustManager().orElseThrow());
        ConnectionSpec tls = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build();
        okHttpClientBuilder.connectionSpecs(Arrays.asList(tls, ConnectionSpec.CLEARTEXT));
        if (httpConfig.getProxy() != null) {
            okHttpClientBuilder.proxy(httpConfig.getProxy());
        }
        if (StringUtils.isNotBlank((CharSequence)httpConfig.getProxyUser())) {
            okHttpClientBuilder.proxyAuthenticator((route, response) -> {
                if (response.request().header(PROXY_AUTHORIZATION) != null) {
                    return null;
                }
                if (407 == response.code()) {
                    String credential = Credentials.basic((String)httpConfig.getProxyUser(), (String)Optional.ofNullable(httpConfig.getProxyPassword()).orElse(""), (Charset)StandardCharsets.UTF_8);
                    return response.request().newBuilder().header(PROXY_AUTHORIZATION, credential).build();
                }
                return null;
            });
        }
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOG).debug(arg_0));
        logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        return okHttpClientBuilder.build();
    }

    private static SSLFactory configureSsl(SslConfig sslConfig, boolean skipSystemTrustMaterial) {
        CertificateStore trustStoreConfig;
        CertificateStore keyStoreConfig;
        SSLFactory.Builder sslFactoryBuilder = SSLFactory.builder().withDefaultTrustMaterial();
        if (!skipSystemTrustMaterial) {
            LOG.debug("Loading OS trusted SSL certificates...");
            LOG.debug("This operation might be slow or even get stuck. You can skip it by passing the scanner property '{}=true'", (Object)"sonar.scanner.skipSystemTruststore");
            sslFactoryBuilder.withSystemTrustMaterial();
        }
        if ((keyStoreConfig = sslConfig.getKeyStore()) != null) {
            keyStoreConfig.getKeyStorePassword().ifPresentOrElse(password -> sslFactoryBuilder.withIdentityMaterial(keyStoreConfig.getPath(), password.toCharArray(), keyStoreConfig.getKeyStoreType()), () -> OkHttpClientFactory.loadIdentityMaterialWithDefaultPassword(sslFactoryBuilder, keyStoreConfig.getPath()));
        }
        if ((trustStoreConfig = sslConfig.getTrustStore()) != null) {
            KeyStore trustStore;
            try {
                trustStore = OkHttpClientFactory.loadTrustStoreWithBouncyCastle(trustStoreConfig.getPath(), trustStoreConfig.getKeyStorePassword().orElse(null), trustStoreConfig.getKeyStoreType(), trustStoreConfig.isFromJvm());
                LOG.debug("Loaded truststore from '{}' containing {} certificates", (Object)trustStoreConfig.getPath(), (Object)trustStore.size());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new GenericKeyStoreException("Unable to read truststore from '" + String.valueOf(trustStoreConfig.getPath()) + "'", (Throwable)e);
            }
            sslFactoryBuilder.withTrustMaterial(trustStore);
        }
        return sslFactoryBuilder.build();
    }

    private static void loadIdentityMaterialWithDefaultPassword(SSLFactory.Builder sslFactoryBuilder, Path path) {
        try {
            KeyStore keystore = KeyStoreUtils.loadKeyStore((Path)path, (char[])"changeit".toCharArray(), (String)"PKCS12");
            sslFactoryBuilder.withIdentityMaterial(keystore, "changeit".toCharArray());
        }
        catch (GenericKeyStoreException e) {
            KeyStore keystore = KeyStoreUtils.loadKeyStore((Path)path, (char[])"sonar".toCharArray(), (String)"PKCS12");
            LOG.warn("Using deprecated default password for keystore '{}'.", (Object)path);
            sslFactoryBuilder.withIdentityMaterial(keystore, "sonar".toCharArray());
        }
    }

    static KeyStore loadTrustStoreWithBouncyCastle(Path keystorePath, @Nullable String keystorePassword, String keystoreType, boolean fromJvm) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keystore;
        block4: {
            Properties.setThreadOverride((String)BC_IGNORE_USELESS_PASSWD, (boolean)true);
            keystore = KeyStore.getInstance(keystoreType, (Provider)new BouncyCastleProvider());
            if (keystorePassword != null) {
                OkHttpClientFactory.loadKeyStoreWithPassword(keystorePath, keystore, keystorePassword);
            } else {
                try {
                    OkHttpClientFactory.loadKeyStoreWithPassword(keystorePath, keystore, "changeit");
                }
                catch (Exception e) {
                    if (fromJvm) break block4;
                    OkHttpClientFactory.loadKeyStoreWithPassword(keystorePath, keystore, "sonar");
                    LOG.warn("Using deprecated default password for truststore '{}'.", (Object)keystorePath);
                }
            }
        }
        return keystore;
    }

    private static void loadKeyStoreWithPassword(Path keystorePath, KeyStore keystore, String oldDefaultPassword) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream keystoreInputStream = Files.newInputStream(keystorePath, StandardOpenOption.READ);){
            keystore.load(keystoreInputStream, oldDefaultPassword.toCharArray());
        }
    }

    static {
        COOKIE_MANAGER.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        COOKIE_JAR = new JavaNetCookieJar((CookieHandler)COOKIE_MANAGER);
    }
}

