/*
 * Decompiled with CFR 0.152.
 */
package org.specsy.junit5;

import fi.jumi.api.RunVia;
import fi.jumi.api.drivers.SuiteNotifier;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.ExecutionRequest;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestEngine;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.discovery.ClassSelector;
import org.junit.gen5.engine.discovery.ClasspathSelector;
import org.junit.gen5.engine.discovery.PackageSelector;
import org.junit.gen5.engine.discovery.UniqueIdSelector;
import org.junit.gen5.engine.support.descriptor.EngineDescriptor;
import org.specsy.Specsy;
import org.specsy.bootstrap.ClassSpec;
import org.specsy.core.Path;
import org.specsy.core.Spec;
import org.specsy.core.SpecRun;
import org.specsy.junit5.ClassTestDescriptor;
import org.specsy.junit5.SuiteNotifierAdapter;

public class SpecsyTestEngine
implements TestEngine {
    private static final String ENGINE_ID = "specsy";

    public String getId() {
        return ENGINE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest) {
        EngineDescriptor engineDescriptor = new EngineDescriptor(this.getId(), "Specsy");
        for (ClassSelector selector : discoveryRequest.getSelectorsByType(ClassSelector.class)) {
            Class testClass = selector.getTestClass();
            if (!SpecsyTestEngine.isSpecsyClass(testClass)) continue;
            engineDescriptor.addChild((TestDescriptor)new ClassTestDescriptor(engineDescriptor, testClass));
        }
        for (ClassSelector selector : discoveryRequest.getSelectorsByType(ClasspathSelector.class)) {
            File classpathRoot = selector.getClasspathRoot();
            for (Class<?> testClass : ReflectionUtils.findAllClassesInClasspathRoot((File)classpathRoot, SpecsyTestEngine::isSpecsyClass)) {
                engineDescriptor.addChild((TestDescriptor)new ClassTestDescriptor(engineDescriptor, testClass));
            }
        }
        for (ClassSelector selector : discoveryRequest.getSelectorsByType(PackageSelector.class)) {
            String packageName = selector.getPackageName();
            for (Class<?> testClass : ReflectionUtils.findAllClassesInPackage((String)packageName, SpecsyTestEngine::isSpecsyClass)) {
                engineDescriptor.addChild((TestDescriptor)new ClassTestDescriptor(engineDescriptor, testClass));
            }
        }
        for (ClassSelector selector : discoveryRequest.getSelectorsByType(UniqueIdSelector.class)) {
            Class<?> testClass;
            String uniqueId = selector.getUniqueId();
            if (!uniqueId.startsWith("specsy:")) continue;
            String[] parts = uniqueId.split(":");
            testClass = SpecsyTestEngine.loadClass(parts[1]);
            Path pathToExecute = Path.of((int[])Stream.of(parts).skip(2L).mapToInt(Integer::parseInt).toArray());
            engineDescriptor.addChild((TestDescriptor)new ClassTestDescriptor(engineDescriptor, testClass, pathToExecute));
        }
        return engineDescriptor;
    }

    private static boolean isSpecsyClass(Class<?> testClass) {
        RunVia runVia = testClass.getAnnotation(RunVia.class);
        return runVia != null && runVia.value() == Specsy.class;
    }

    private static Class<?> loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(ExecutionRequest request) {
        this.execute(request.getRootTestDescriptor(), request.getEngineExecutionListener());
    }

    private void execute(TestDescriptor descriptor, EngineExecutionListener listener) {
        if (descriptor instanceof EngineDescriptor) {
            this.execute((EngineDescriptor)descriptor, listener);
        } else if (descriptor instanceof ClassTestDescriptor) {
            this.execute((ClassTestDescriptor)descriptor, listener);
        } else {
            throw new IllegalArgumentException("Unrecognized descriptor: " + descriptor);
        }
    }

    private void execute(EngineDescriptor descriptor, EngineExecutionListener listener) {
        listener.executionStarted((TestDescriptor)descriptor);
        for (TestDescriptor child : descriptor.getChildren()) {
            this.execute(child, listener);
        }
        listener.executionFinished((TestDescriptor)descriptor, new TestExecutionResult(TestExecutionResult.Status.SUCCESSFUL, null));
    }

    private void execute(ClassTestDescriptor descriptor, EngineExecutionListener listener) {
        ClassSpec spec = new ClassSpec(descriptor.getTestClass());
        Path pathToExecute = descriptor.getPathToExecute();
        SuiteNotifierAdapter notifier = new SuiteNotifierAdapter(listener, descriptor);
        AsyncThreadlessExecutor executor = new AsyncThreadlessExecutor();
        executor.execute((Runnable)new SpecRun((Spec)spec, pathToExecute, (SuiteNotifier)notifier, (Executor)executor));
        executor.executeUntilDone();
    }

    private static class AsyncThreadlessExecutor
    implements Executor {
        private final Queue<Runnable> commands = new ConcurrentLinkedQueue<Runnable>();

        private AsyncThreadlessExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            this.commands.add(command);
        }

        public void executeUntilDone() {
            Runnable command;
            while ((command = this.commands.poll()) != null) {
                command.run();
            }
        }
    }
}

