/*
 * Decompiled with CFR 0.152.
 */
package org.specsy.junit5;

import fi.jumi.api.drivers.SuiteNotifier;
import fi.jumi.api.drivers.TestId;
import fi.jumi.api.drivers.TestNotifier;
import java.util.HashMap;
import java.util.Map;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.TestDescriptor;
import org.specsy.junit5.ClassTestDescriptor;
import org.specsy.junit5.NestedTestDescriptor;
import org.specsy.junit5.TestNotifierAdapter;

public class SuiteNotifierAdapter
implements SuiteNotifier {
    private final EngineExecutionListener listener;
    private final Map<TestId, TestDescriptor> descriptorsByTestId = new HashMap<TestId, TestDescriptor>();

    public SuiteNotifierAdapter(EngineExecutionListener listener, ClassTestDescriptor rootDescriptor) {
        this.listener = listener;
        this.descriptorsByTestId.put(TestId.ROOT, (TestDescriptor)rootDescriptor);
    }

    public void fireTestFound(TestId testId, String name) {
        this.descriptorsByTestId.computeIfAbsent(testId, k -> this.createTestDescriptor(testId, name));
    }

    private TestDescriptor createTestDescriptor(TestId testId, String name) {
        TestDescriptor parent = this.descriptorsByTestId.get(testId.getParent());
        NestedTestDescriptor descriptor = new NestedTestDescriptor(parent, testId, name);
        parent.addChild((TestDescriptor)descriptor);
        this.listener.dynamicTestRegistered((TestDescriptor)descriptor);
        return descriptor;
    }

    public TestNotifier fireTestStarted(TestId testId) {
        TestDescriptor descriptor = this.getTestDescriptor(testId);
        this.listener.executionStarted(descriptor);
        return new TestNotifierAdapter(this.listener, descriptor);
    }

    private TestDescriptor getTestDescriptor(TestId testId) {
        return this.descriptorsByTestId.computeIfAbsent(testId, key -> {
            throw new IllegalStateException("key not found: " + key);
        });
    }

    public void fireInternalError(String message, Throwable cause) {
        throw new RuntimeException("Internal error: " + message, cause);
    }
}

