/*
 * Decompiled with CFR 0.152.
 */
package org.specsy.junit5;

import fi.jumi.api.drivers.TestNotifier;
import java.util.LinkedList;
import java.util.List;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestExecutionResult;
import org.opentest4j.MultipleFailuresError;

public class TestNotifierAdapter
implements TestNotifier {
    private final TestDescriptor descriptor;
    private final List<Throwable> failures = new LinkedList<Throwable>();
    private EngineExecutionListener listener;

    public TestNotifierAdapter(EngineExecutionListener listener, TestDescriptor descriptor) {
        this.descriptor = descriptor;
        this.listener = listener;
    }

    public void fireFailure(Throwable cause) {
        this.failures.add(cause);
    }

    public void fireTestFinished() {
        this.listener.executionFinished(this.descriptor, TestNotifierAdapter.toResult(this.failures));
    }

    private static TestExecutionResult toResult(List<Throwable> failures) {
        return new TestExecutionResult(failures.isEmpty() ? TestExecutionResult.Status.SUCCESSFUL : TestExecutionResult.Status.FAILED, TestNotifierAdapter.mergeFailures(failures));
    }

    private static Throwable mergeFailures(List<Throwable> failures) {
        if (failures.isEmpty()) {
            return null;
        }
        if (failures.size() == 1) {
            return failures.get(0);
        }
        MultipleFailuresError multiple = new MultipleFailuresError(null);
        for (Throwable failure : failures) {
            if (failure instanceof AssertionError) {
                multiple.addFailure((AssertionError)((Object)failure));
                continue;
            }
            multiple.addFailure(new AssertionError((Object)failure));
        }
        return multiple;
    }
}

