/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.Schema;

public final class SchemaRefWriter {
    private static final boolean SCHEMA_REFS_SUPORTED;

    private SchemaRefWriter() {
    }

    public static boolean isSchemaRefsSupported() {
        return SCHEMA_REFS_SUPORTED;
    }

    public static void write(Schema schema, OutputStream os) throws IOException {
        JsonGenerator jgen = Schema.FACTORY.createGenerator(os);
        schema.toJson((Schema.Names)(SCHEMA_REFS_SUPORTED ? new NamesExt(schema.getFullName()) : new Schema.Names()), jgen);
        jgen.flush();
    }

    static {
        boolean schemaRefsSupported;
        try {
            Schema.Names.class.getMethod("getId", Schema.class);
            schemaRefsSupported = true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            schemaRefsSupported = false;
        }
        SCHEMA_REFS_SUPORTED = schemaRefsSupported;
    }

    private static final class NamesExt
    extends Schema.Names {
        private static final long serialVersionUID = 1L;
        private final String exclude;

        NamesExt(String exclude) {
            this.exclude = exclude;
        }

        @Nullable
        public String getId(Schema schema) {
            String id = schema.getProp("mvnId");
            if (id == null) {
                return null;
            }
            if (Objects.equals(schema.getFullName(), this.exclude)) {
                return null;
            }
            return id;
        }
    }
}

