/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaRefWriter;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.version.Version;
import org.spf4j.base.AppendableUtils;
import org.spf4j.base.PackageInfo;
import org.spf4j.base.Runtime;
import org.spf4j.io.compress.Compress;
import org.spf4j.maven.MavenRepositoryUtils;
import org.spf4j.maven.plugin.avro.avscp.SchemaMojoBase;
import org.spf4j.maven.plugin.avro.avscp.SourceLocation;

@Mojo(name="avro-compile", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class SchemaCompileMojo
extends SchemaMojoBase {
    public static final String SCHEMA_INDEX_FILENAME = "schema_index.properties";
    public static final String SCHEMA_INDEX_PGK_KEY = "_pkg";
    public static final String SCHEMA_MANIFEST = "codegen.properties";
    @Parameter(name="fieldVisibility", defaultValue="PRIVATE")
    private String fieldVisibility;
    @Parameter(name="templateDirectory", defaultValue="/org/apache/avro/compiler/specific/templates/java/classic/")
    private String templateDirectory;
    @Parameter(name="createSetters", defaultValue="false")
    private boolean createSetters;
    @Parameter(name="addMavenId", defaultValue="true")
    private boolean addMavenId = true;
    @Parameter(name="deleteProtocolInterface", defaultValue="true")
    private boolean deleteProtocolInterface = true;
    @Parameter(name="systemProperties")
    private Properties systemProperties = new Properties();
    @Parameter(name="stringType", defaultValue="String")
    private String stringType = "String";
    private int idSequence = 0;
    private final Map<String, Schema> index = new HashMap<String, Schema>();
    private final Map<String, Integer> prevReleaseName2Index = new HashMap<String, Integer>();

    private void loadPrevReleaseId2Map() throws IOException {
        File prevSchemaArchive;
        List rangeVersions;
        MavenProject mavenProject = this.getMavenProject();
        Log log = this.getLog();
        String versionRange = "[," + mavenProject.getVersion() + ')';
        String groupId = mavenProject.getGroupId();
        String artifactId = mavenProject.getArtifactId();
        List remoteProjectRepositories = mavenProject.getRemoteProjectRepositories();
        RepositorySystem repoSystem = this.getRepoSystem();
        RepositorySystemSession repositorySession = this.getMavenSession().getRepositorySession();
        try {
            rangeVersions = MavenRepositoryUtils.getVersions((String)groupId, (String)artifactId, (String)versionRange, (List)remoteProjectRepositories, (RepositorySystem)repoSystem, (RepositorySystemSession)repositorySession);
        }
        catch (VersionRangeResolutionException ex) {
            throw new RuntimeException("Invalid compatibiliy.versionRange = " + versionRange + " setting", ex);
        }
        rangeVersions = rangeVersions.stream().filter(v -> !v.toString().endsWith("SNAPSHOT")).collect(Collectors.toList());
        int tSize = rangeVersions.size();
        rangeVersions = rangeVersions.subList(Math.max(tSize - 1, 0), tSize);
        log.info((CharSequence)("Loading id 2 name map from " + rangeVersions));
        if (rangeVersions.isEmpty()) {
            return;
        }
        Version version = (Version)rangeVersions.get(0);
        Path targetPath = this.getTarget().toPath();
        try {
            prevSchemaArchive = MavenRepositoryUtils.resolveArtifact((String)groupId, (String)artifactId, (String)this.schemaArtifactClassifier, (String)this.schemaArtifactExtension, (String)version.toString(), (List)remoteProjectRepositories, (RepositorySystem)repoSystem, (RepositorySystemSession)repositorySession);
        }
        catch (ArtifactResolutionException ex) {
            throw new RuntimeException("Cannot resolve previous version " + version, ex);
        }
        Path dest = targetPath.resolve("prevSchema").resolve(version.toString());
        Files.createDirectories(dest, new FileAttribute[0]);
        log.debug((CharSequence)("Unzipping " + prevSchemaArchive + " to " + dest));
        List indexFiles = Compress.unzip2((Path)prevSchemaArchive.toPath(), (Path)dest, p -> {
            Path fileName = p.getFileName();
            if (fileName == null) {
                return false;
            }
            return SCHEMA_INDEX_FILENAME.equals(fileName.toString());
        });
        Properties prevIndex = new Properties();
        if (indexFiles.size() != 1) {
            log.info((CharSequence)("no index file or to many in previous version: " + indexFiles));
        } else {
            Path indexFile = (Path)indexFiles.get(0);
            try (BufferedReader br = Files.newBufferedReader(indexFile, StandardCharsets.UTF_8);){
                prevIndex.load(br);
            }
        }
        for (Map.Entry<Object, Object> entry : prevIndex.entrySet()) {
            String key = (String)entry.getKey();
            if (SCHEMA_INDEX_PGK_KEY.equals(key)) continue;
            int idx = Integer.parseInt(key, 32);
            if (idx >= this.idSequence) {
                this.idSequence = idx + 1;
            }
            this.prevReleaseName2Index.put((String)entry.getValue(), idx);
        }
        log.debug((CharSequence)("loaded existing mappings: " + this.prevReleaseName2Index));
        log.info((CharSequence)("loaded existing mappings, new id sequence: " + this.idSequence));
    }

    private String attachMavenId(Schema schema) {
        String exMvnId = schema.getProp("mvnId");
        if (exMvnId == null) {
            String newId = this.genMnvId(schema);
            schema.addProp("mvnId", newId);
            return newId;
        }
        return exMvnId;
    }

    public CharSequence getPackageMvnIdPrefix() {
        StringBuilder idBuilder = new StringBuilder(64);
        idBuilder.append(this.mavenProject.getGroupId()).append(':').append(this.mavenProject.getArtifactId()).append(':').append(this.mavenProject.getVersion());
        return idBuilder;
    }

    public String genMnvId(Schema schema) {
        StringBuilder idBuilder = new StringBuilder(64);
        idBuilder.append(this.mavenProject.getGroupId()).append(':').append(this.mavenProject.getArtifactId()).append(':').append(this.mavenProject.getVersion());
        Integer idx = this.prevReleaseName2Index.get(schema.getFullName());
        if (idx == null) {
            idx = this.idSequence++;
        }
        StringBuilder idb = new StringBuilder(4);
        AppendableUtils.appendUnsignedString((StringBuilder)idb, (int)idx, (int)5);
        idBuilder.append(':').append((CharSequence)idb);
        this.index.put(idb.toString(), schema);
        return idBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCompileIDL(File sourceDir, String filename) throws IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            Idl parser;
            List<URL> runtimeUrls = this.createPathUrls(sourceDir);
            URLClassLoader projPathLoader = AccessController.doPrivileged(() -> new URLClassLoader(runtimeUrls.toArray(new URL[runtimeUrls.size()]), contextClassLoader));
            currentThread.setContextClassLoader(projPathLoader);
            File file = new File(sourceDir, filename);
            String sourceAbsolutePath = sourceDir.getAbsolutePath();
            String origCurrentDir = Runtime.getCurrentDir();
            Runtime.setCurrentDir((String)sourceAbsolutePath);
            try {
                parser = new Idl(file, (ClassLoader)projPathLoader);
            }
            finally {
                Runtime.setCurrentDir((String)origCurrentDir);
            }
            Protocol protocol = parser.CompilationUnit();
            this.publishSchemasAndAttachMvnIdToProtocol(protocol, false, this.useSchemaReferencesForAvsc);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.setOutputCharacterEncoding(this.mavenProject.getProperties().getProperty("project.build.sourceEncoding"));
            compiler.setStringType(GenericData.StringType.valueOf((String)this.stringType));
            compiler.setTemplateDir(this.templateDirectory);
            compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.valueOf((String)this.fieldVisibility));
            compiler.setCreateSetters(this.createSetters);
            compiler.compileToDestination(null, this.generatedJavaTarget);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        catch (DependencyResolutionRequiredException drre) {
            throw new IOException(drre);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public List<URL> createPathUrls(File sourceFolder) throws MalformedURLException, DependencyResolutionRequiredException {
        List cpElements = this.mavenProject.getRuntimeClasspathElements();
        ArrayList<URL> runtimeUrls = new ArrayList<URL>();
        runtimeUrls.add(sourceFolder.toURI().toURL());
        if (cpElements != null && !cpElements.isEmpty()) {
            for (Object runtimeClasspathElement : cpElements) {
                String element = (String)runtimeClasspathElement;
                runtimeUrls.add(new File(element).toURI().toURL());
            }
        }
        return runtimeUrls;
    }

    private File addMvnIdsToIdl(File idl, URLClassLoader cl) throws IOException, ParseException {
        if (!this.addMavenId) {
            return idl;
        }
        String charsetStr = this.mavenProject.getProperties().getProperty("project.build.sourceEncoding");
        Charset charset = charsetStr == null ? Charset.defaultCharset() : Charset.forName(charsetStr);
        List<String> readAllLines = Files.readAllLines(idl.toPath(), charset);
        Idl parser = new Idl(idl, (ClassLoader)cl);
        Protocol protocol = parser.CompilationUnit();
        String idlSource = new File(".").toURI().relativize(idl.toURI()).toString();
        this.getLog().debug((CharSequence)("Injecting mvnIds to " + idlSource));
        for (Schema s : protocol.getTypes()) {
            if (s.getProp("mvnId") != null) continue;
            String sourceIdl = s.getProp("sourceIdl");
            if (sourceIdl == null) {
                this.getLog().warn((CharSequence)"sourceIdl not available, will not attach mvnId for IDLs");
                continue;
            }
            SourceLocation sl = new SourceLocation(sourceIdl);
            if (!idlSource.equals(sl.getFilePath())) continue;
            int zbLineNr = sl.getLineNr() - 1;
            String line = readAllLines.get(zbLineNr);
            String sMvnId = this.genMnvId(s);
            this.getLog().debug((CharSequence)("inserting mvnId: " + sMvnId + " at " + sl + " for line \"" + line + "\" schema: " + s.getFullName()));
            int zbColNr = sl.getColNr() - 1;
            readAllLines.set(zbLineNr, line.substring(0, zbColNr) + " @mvnId(\"" + sMvnId + "\") " + line.substring(zbColNr, line.length()));
        }
        Path tempIdl = Files.createTempFile(this.target.toPath(), idl.getName(), ".tmp", new FileAttribute[0]);
        Files.write(tempIdl, readAllLines, charset, new OpenOption[0]);
        return tempIdl.toFile();
    }

    protected void doCompileSchemas(String[] filenames) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        for (String fileName : filenames) {
            File src = new File(this.sourceDirectory, fileName);
            Schema schema = parser.parse(src);
            if (this.addMavenId) {
                this.attachMavenId(schema);
            }
            String targetName = schema.getFullName().replace('.', File.separatorChar) + ".avsc";
            Path destination = this.generatedAvscTarget.toPath().resolve(targetName);
            Path parent = destination.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(destination, schema.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            SpecificCompiler compiler = new SpecificCompiler(schema);
            compiler.setOutputCharacterEncoding(this.mavenProject.getProperties().getProperty("project.build.sourceEncoding"));
            compiler.setTemplateDir(this.templateDirectory);
            compiler.setStringType(GenericData.StringType.valueOf((String)this.stringType));
            compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.valueOf((String)this.fieldVisibility));
            compiler.setCreateSetters(this.createSetters);
            compiler.compileToDestination(src, this.generatedJavaTarget);
        }
    }

    protected void doCompileProtocol(String filename, Path destination) throws IOException {
        File src = new File(this.sourceDirectory, filename);
        Protocol protocol = Protocol.parse((File)src);
        this.publishSchemasAndAttachMvnIdToProtocol(protocol, this.addMavenId, this.useSchemaReferencesForAvsc);
        SpecificCompiler compiler = new SpecificCompiler(protocol);
        compiler.setOutputCharacterEncoding(this.mavenProject.getProperties().getProperty("project.build.sourceEncoding"));
        compiler.setTemplateDir(this.templateDirectory);
        compiler.setStringType(GenericData.StringType.valueOf((String)this.stringType));
        compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.valueOf((String)this.fieldVisibility));
        compiler.setCreateSetters(this.createSetters);
        compiler.compileToDestination(src, this.generatedJavaTarget);
        Files.write(destination, protocol.toString(true).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void publishSchemasAndAttachMvnIdToProtocol(Protocol protocol, boolean addMvnId, boolean useSchemaReferences) throws IOException {
        Collection types = protocol.getTypes();
        HashSet typeNames = Sets.newHashSetWithExpectedSize((int)types.size());
        for (Schema schema : types) {
            String fullName = schema.getFullName();
            if (!typeNames.add(fullName)) continue;
            String targetName = fullName.replace('.', File.separatorChar) + ".avsc";
            Path destinationFile = this.generatedAvscTarget.toPath().resolve(targetName);
            Path parent = destinationFile.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (addMvnId) {
                this.attachMavenId(schema);
            }
            if (useSchemaReferences) {
                BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(destinationFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                Throwable throwable = null;
                try {
                    SchemaRefWriter.write(schema, fos);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)fos).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)fos).close();
                    continue;
                }
            }
            Files.write(destinationFile, schema.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public void deleteGeneratedAvailableInDependencies() throws IOException {
        Path classesInfo = this.dependenciesDirectory.toPath().resolve("classes.txt");
        HashSet<String> classes = new HashSet<String>(Files.readAllLines(classesInfo, StandardCharsets.UTF_8));
        Path javaPath = this.generatedJavaTarget.toPath();
        try (Stream<Path> fsStream = Files.walk(javaPath, new FileVisitOption[0]);){
            List dupes = fsStream.filter(p -> {
                Path relativize = javaPath.relativize((Path)p);
                return classes.contains(relativize.toString().replace(".java", ".class"));
            }).collect(Collectors.toList());
            for (Path p2 : dupes) {
                Files.delete(p2);
                this.getLog().info((CharSequence)("Deleted dupes: " + dupes));
            }
        }
    }

    public void deleteProtocolClasses() throws IOException {
        String detectionString = "org.apache.avro.Protocol PROTOCOL";
        Path javaPath = this.generatedJavaTarget.toPath();
        String mSourceEncoding = this.mavenProject.getProperties().getProperty("project.build.sourceEncoding");
        String sourceEncoding = mSourceEncoding == null ? Charset.defaultCharset().name() : mSourceEncoding;
        try (Stream<Path> fsStream = Files.walk(javaPath, new FileVisitOption[0]);){
            List protocolFiles = fsStream.filter(p -> {
                Path fileName = p.getFileName();
                if (fileName == null) return false;
                if (!fileName.toString().endsWith(".java")) {
                    return false;
                }
                try (BufferedReader br = Files.newBufferedReader(p, Charset.forName(sourceEncoding));){
                    String line;
                    do {
                        if ((line = br.readLine()) == null) return false;
                    } while (!line.contains(detectionString));
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.getLog().info((CharSequence)("cannot read file " + p + ", ignoring for cleanup"), (Throwable)ex);
                }
                return false;
            }).collect(Collectors.toList());
            for (Path p2 : protocolFiles) {
                Files.delete(p2);
            }
        }
    }

    public void deleteSchemasAvailableInDependencies(Path schTargetPath) throws IOException {
        Path classesInfo = this.dependenciesDirectory.toPath();
        Set schemas = Files.walk(classesInfo, new FileVisitOption[0]).filter(p -> {
            Path fileName = p.getFileName();
            return fileName == null ? false : fileName.toString().endsWith("avsc");
        }).map(p -> classesInfo.relativize((Path)p)).collect(Collectors.toSet());
        List dupes = Files.walk(schTargetPath, new FileVisitOption[0]).filter(p -> schemas.contains(schTargetPath.relativize((Path)p))).collect(Collectors.toList());
        for (Path p2 : dupes) {
            Files.delete(p2);
        }
        this.getLog().info((CharSequence)("Deleted dupes: " + dupes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.loadPrevReleaseId2Map();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to proces previous release of " + this.getMavenProject().getVersion(), (Exception)ex);
        }
        super.execute();
        Log logger = this.getLog();
        logger.info((CharSequence)("Generationg java code + schemas, using avro " + PackageInfo.getPackageInfo((String)Schema.class.getName())));
        Class<String> clazz = String.class;
        synchronized (String.class) {
            Properties properties = new Properties(System.getProperties());
            try {
                for (Map.Entry<Object, Object> entry : this.systemProperties.entrySet()) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                Path generatedAvscTargetPath = this.generatedAvscTarget.toPath();
                Files.createDirectories(generatedAvscTargetPath, new FileAttribute[0]);
                Files.createDirectories(this.generatedJavaTarget.toPath(), new FileAttribute[0]);
                Object[] sourceFiles = this.getSourceFiles("**/*.avsc");
                try {
                    this.doCompileSchemas((String[])sourceFiles);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("cannot compile schemas " + Arrays.toString(sourceFiles), (Exception)ex);
                }
                Path tmpSourceTarget = this.target.toPath().resolve("avro-sources");
                this.compileAvpr(tmpSourceTarget);
                this.addMvnIdToIdlsAndMoveToDestination(tmpSourceTarget);
                this.compileIdl(tmpSourceTarget);
                Path codegenManifest = generatedAvscTargetPath.resolve(SCHEMA_MANIFEST);
                try {
                    Files.write(codegenManifest, Collections.singletonList("Build-Time=" + DateTimeFormatter.ISO_INSTANT.format(Instant.now()) + '\n'), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Cannot create codegen manifest file " + codegenManifest, (Exception)ex);
                }
                try {
                    this.deleteGeneratedAvailableInDependencies();
                    this.deleteSchemasAvailableInDependencies(this.getGeneratedAvscTarget().toPath());
                    if (this.deleteProtocolInterface) {
                        this.deleteProtocolClasses();
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Cannot delete dependency dupes " + (Object)((Object)this), (Exception)ex);
                }
                Path indexFile = generatedAvscTargetPath.resolve(SCHEMA_INDEX_FILENAME);
                try (BufferedWriter bw = Files.newBufferedWriter(indexFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    bw.append(SCHEMA_INDEX_PGK_KEY);
                    bw.append('=');
                    bw.append(this.getPackageMvnIdPrefix());
                    bw.append('\n');
                    for (Map.Entry<String, Schema> entry : this.index.entrySet()) {
                        bw.append(entry.getKey());
                        bw.append('=');
                        bw.append(entry.getValue().getFullName());
                        bw.append('\n');
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Cannot generate schema index " + (Object)((Object)this), (Exception)ex);
                }
                this.mavenProject.addCompileSourceRoot(this.generatedJavaTarget.getAbsolutePath());
                Resource resource = new Resource();
                resource.setDirectory(this.generatedAvscTarget.getAbsolutePath());
                resource.addInclude("**/*.avsc");
                resource.addInclude("*.properties");
                this.mavenProject.addResource(resource);
                Resource resource2 = new Resource();
                resource2.setDirectory(tmpSourceTarget.toString());
                resource2.addInclude("**/*.avpr");
                resource2.addInclude("**/*.avdl");
                this.mavenProject.addResource(resource2);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("cannot compile schemas, cfg = " + (Object)((Object)this), (Exception)ex);
            }
            finally {
                System.setProperties(properties);
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public void compileIdl(Path pSources) throws MojoExecutionException {
        File pSourcesFile = pSources.toFile();
        for (String file : SchemaCompileMojo.getFiles(pSourcesFile, "**/*.avdl")) {
            try {
                this.doCompileIDL(pSourcesFile, file);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("cannot compile " + file, (Exception)ex);
            }
        }
    }

    public void addMvnIdToIdlsAndMoveToDestination(Path destPath) throws MojoExecutionException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            List<URL> runtimeUrls = this.createPathUrls(this.sourceDirectory);
            this.getLog().info((CharSequence)("Compile classpath: " + runtimeUrls));
            URLClassLoader projPathLoader = AccessController.doPrivileged(() -> new URLClassLoader(runtimeUrls.toArray(new URL[runtimeUrls.size()]), contextClassLoader));
            currentThread.setContextClassLoader(projPathLoader);
            for (String file : this.getSourceFiles("**/*.avdl")) {
                Path destination = destPath.resolve(file);
                Path parent = destination.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                File idlFile = new File(this.sourceDirectory, file);
                try {
                    idlFile = this.addMvnIdsToIdl(idlFile, projPathLoader);
                }
                catch (IOException | RuntimeException | ParseException ex) {
                    throw new MojoExecutionException("cannot add mvnId to  IDL " + idlFile + ", " + ex.getMessage(), (Exception)ex);
                }
                Files.copy(idlFile.toPath(), destination, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException | DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("cannot add mvnId to  IDL " + (Object)((Object)this), (Exception)ex);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void compileAvpr(Path pSources) throws MojoExecutionException {
        for (String file : this.getSourceFiles("**/*.avpr")) {
            try {
                Path destination = pSources.resolve(file);
                Path folder = destination.getParent();
                if (folder != null) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                }
                this.doCompileProtocol(file, destination);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("cannot compile protocol " + file, (Exception)ex);
            }
        }
    }

    public String[] getSourceFiles(String pattern) {
        FileSetManager fsm = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(this.sourceDirectory.getAbsolutePath());
        fs.addInclude(pattern);
        fs.setFollowSymlinks(false);
        return fsm.getIncludedFiles(fs);
    }

    public static String[] getFiles(File directory, String pattern) {
        FileSetManager fsm = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(directory.getAbsolutePath());
        fs.addInclude(pattern);
        fs.setFollowSymlinks(false);
        return fsm.getIncludedFiles(fs);
    }

    @Override
    public String toString() {
        return "SchemaCompileMojo{fieldVisibility=" + this.fieldVisibility + ", templateDirectory=" + this.templateDirectory + ", createSetters=" + this.createSetters + ", addMavenId=" + this.addMavenId + ", " + super.toString() + '}';
    }
}

